/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJFloatRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJFloatRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJFloatRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractFloatAssertIsCloseToWithOffsetRecipe(), new AbstractFloatAssertIsZeroRecipe(), new AbstractFloatAssertIsNotZeroRecipe(), new AbstractFloatAssertIsOneRecipe()});
    }

    @NonNullApi
    public static class AbstractFloatAssertIsCloseToWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsCloseToWithOffset`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsCloseToWithOffset {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {\n        return floatAssert.isEqualTo(n, offset);\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, Float n, Offset<Float> offset) {\n        return floatAssert.isEqualTo(n, offset);\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {\n        return floatAssert.isCloseTo(n, offset);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (floatAssert, n, offset) -> floatAssert.isEqualTo(n, offset)).build();
                final JavaTemplate before0 = Semantics.expression((JavaVisitor)this, (String)"before0", (floatAssert, n, offset) -> floatAssert.isEqualTo(n, offset)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (floatAssert, n, offset) -> floatAssert.isCloseTo(n, offset)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.data.Offset", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isEqualTo(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractFloatAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", floatAssert -> floatAssert.isZero()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", floatAssert -> floatAssert.isEqualTo(0.0f)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractFloatAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", floatAssert -> floatAssert.isNotZero()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", floatAssert -> floatAssert.isNotEqualTo(0.0f)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isNotZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractFloatAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJFloatRules.AbstractFloatAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractFloatAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {\n        return floatAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", floatAssert -> floatAssert.isOne()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", floatAssert -> floatAssert.isEqualTo(1.0f)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isOne(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

