/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJLongRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJLongRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJLongRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractLongAssertIsZeroRecipe(), new AbstractLongAssertIsNotZeroRecipe(), new AbstractLongAssertIsOneRecipe()});
    }

    @NonNullApi
    public static class AbstractLongAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {\n        return longAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {\n        return longAssert.isEqualTo(0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", longAssert -> longAssert.isZero()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", longAssert -> longAssert.isEqualTo(0L)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractLongAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {\n        return longAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {\n        return longAssert.isNotEqualTo(0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", longAssert -> longAssert.isNotZero()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", longAssert -> longAssert.isNotEqualTo(0L)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isNotZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractLongAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJLongRules.AbstractLongAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractLongAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> longAssert) {\n        return longAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractLongAssert<?> after(AbstractLongAssert<?> longAssert) {\n        return longAssert.isEqualTo(1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", longAssert -> longAssert.isOne()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", longAssert -> longAssert.isEqualTo(1L)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isOne(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

