/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJThrowingCallableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to AssertJ assertions over expressions that may throw a `Throwable` subtype";
    }

    public String getDescription() {
        return "<p>For reasons of consistency we prefer `org.assertj.core.api.Assertions#assertThatThrownBy` over static methods for specific exception\n types. Note that only the most common assertion expressions are rewritten here; covering all\n cases would require the implementation of an Error Prone check instead.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatThrownByIllegalArgumentExceptionRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageParametersRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageContainingRecipe(), new AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAnyRecipe(), new AssertThatThrownByIllegalStateExceptionRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageParametersRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageContainingRecipe(), new AssertThatThrownByIllegalStateExceptionHasMessageNotContainingRecipe(), new AssertThatThrownByNullPointerExceptionRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageParametersRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageContainingRecipe(), new AssertThatThrownByNullPointerExceptionHasMessageNotContainingRecipe(), new AssertThatThrownByIOExceptionRecipe(), new AssertThatThrownByIOExceptionHasMessageRecipe(), new AssertThatThrownByIOExceptionHasMessageParametersRecipe(), new AssertThatThrownByIOExceptionHasMessageStartingWithRecipe(), new AssertThatThrownByIOExceptionHasMessageContainingRecipe(), new AssertThatThrownByIOExceptionHasMessageNotContainingRecipe(), new AssertThatThrownByRecipe(), new AssertThatThrownByHasMessageRecipe(), new AssertThatThrownByHasMessageParametersRecipe(), new AssertThatThrownByHasMessageStartingWithRecipe(), new AssertThatThrownByHasMessageContainingRecipe(), new AssertThatThrownByHasMessageNotContainingRecipe(), new AbstractThrowableAssertHasMessageRecipe(), new AbstractThrowableAssertWithFailMessageRecipe()});
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalArgumentExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", throwingCallable -> Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", throwingCallable -> Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessage(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageParametersRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessageParameters`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessageParameters {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message, parameters);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessage(message, parameters);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message, parameters) -> Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message, parameters) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessage(message, new Object[]{parameters})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageStartingWith(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAnyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAny`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAny {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalArgumentException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, @Repeated\n    CharSequence values) {\n        return assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageNotContainingAny(values);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, @Repeated\n    CharSequence values) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalArgumentException.class).hasMessageNotContainingAny(values);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, values) -> Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageNotContainingAny(new CharSequence[]{values})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, values) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageNotContainingAny(new CharSequence[]{values})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalArgumentException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContainingAny(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalArgumentException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalStateExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", throwingCallable -> Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", throwingCallable -> Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalStateExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessage(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalStateExceptionHasMessageParametersRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageParameters`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageParameters {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message, parameters);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessage(message, parameters);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message, parameters) -> Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message, parameters) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessage(message, new Object[]{parameters})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalStateExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageStartingWith(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageStartingWith(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalStateExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIllegalStateExceptionHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIllegalStateExceptionHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIllegalStateExceptionHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIllegalStateException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IllegalStateException.class).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageNotContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageNotContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIllegalStateException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIllegalStateException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByNullPointerExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", throwingCallable -> Assertions.assertThatNullPointerException().isThrownBy(throwingCallable)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", throwingCallable -> Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByNullPointerExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessage(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByNullPointerExceptionHasMessageParametersRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageParameters`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageParameters {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message, parameters);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessage(message, parameters);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message, parameters) -> Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message, parameters) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessage(message, new Object[]{parameters})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByNullPointerExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageStartingWith(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageStartingWith(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByNullPointerExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByNullPointerExceptionHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByNullPointerExceptionHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByNullPointerExceptionHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByNullPointerException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatNullPointerException().isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(NullPointerException.class).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageNotContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageNotContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatNullPointerException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatNullPointerException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIOExceptionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOException`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOException {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable) {\n        return assertThatIOException().isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", throwingCallable -> Assertions.assertThatIOException().isThrownBy(throwingCallable)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", throwingCallable -> Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIOExceptionHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessage(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessage(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIOExceptionHasMessageParametersRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageParameters`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageParameters {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessage(message, parameters);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message, @Repeated\n    Object parameters) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessage(message, parameters);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message, parameters) -> Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message, parameters) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessage(message, new Object[]{parameters})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIOExceptionHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessageStartingWith(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessageStartingWith(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIOExceptionHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessageContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessageContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByIOExceptionHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByIOExceptionHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByIOExceptionHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownByIOException\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, String message) {\n        return assertThatIOException().isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(IOException.class).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, message) -> Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessageNotContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessageNotContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatIOException");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatIOException(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownBy`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownBy {\n    \n    @BeforeTemplate\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, exceptionType) -> Assertions.assertThatExceptionOfType((Class)exceptionType).isThrownBy(throwingCallable)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, exceptionType) -> Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessage {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownBy\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, exceptionType, message) -> Assertions.assertThatExceptionOfType((Class)exceptionType).isThrownBy(throwingCallable).withMessage(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, exceptionType, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessage(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByHasMessageParametersRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageParameters`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageParameters {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownBy\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message, @Repeated\n    Object parameters) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message, parameters);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message, @Repeated\n    Object parameters) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessage(message, parameters);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, exceptionType, message, parameters) -> Assertions.assertThatExceptionOfType((Class)exceptionType).isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, exceptionType, message, parameters) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessage(message, new Object[]{parameters})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessage(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByHasMessageStartingWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageStartingWith`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageStartingWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownBy\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageStartingWith(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessageStartingWith(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, exceptionType, message) -> Assertions.assertThatExceptionOfType((Class)exceptionType).isThrownBy(throwingCallable).withMessageStartingWith(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, exceptionType, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessageStartingWith(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageStartingWith(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByHasMessageContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownBy\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessageContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, exceptionType, message) -> Assertions.assertThatExceptionOfType((Class)exceptionType).isThrownBy(throwingCallable).withMessageContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, exceptionType, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessageContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatThrownByHasMessageNotContainingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AssertThatThrownByHasMessageNotContaining`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatThrownByHasMessageNotContaining {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"AssertThatThrownBy\")\n    AbstractObjectAssert<?, ?> before(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessageNotContaining(message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, ?> after(ThrowingCallable throwingCallable, Class<? extends Throwable> exceptionType, String message) {\n        return assertThatThrownBy(throwingCallable).isInstanceOf(exceptionType).hasMessageNotContaining(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (throwingCallable, exceptionType, message) -> Assertions.assertThatExceptionOfType((Class)exceptionType).isThrownBy(throwingCallable).withMessageNotContaining(message)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (throwingCallable, exceptionType, message) -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessageNotContaining(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.Assertions.assertThatExceptionOfType");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractObjectAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ThrowableAssert.ThrowingCallable", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ThrowableAssertAlternative withMessageNotContaining(..)"), new UsesMethod("org.assertj.core.api.ThrowableTypeAssert isThrownBy(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThatExceptionOfType(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractThrowableAssertHasMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AbstractThrowableAssertHasMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractThrowableAssertHasMessage {\n    \n    @BeforeTemplate\n    AbstractThrowableAssert<?, ? extends Throwable> before(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, @Repeated\n    Object parameters) {\n        return abstractThrowableAssert.hasMessage(String.format(message, parameters));\n    }\n    \n    @AfterTemplate\n    AbstractThrowableAssert<?, ? extends Throwable> after(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, @Repeated\n    Object parameters) {\n        return abstractThrowableAssert.hasMessage(message, parameters);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (abstractThrowableAssert, message, parameters) -> abstractThrowableAssert.hasMessage(String.format(message, parameters))).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (abstractThrowableAssert, message, parameters) -> abstractThrowableAssert.hasMessage(message, new Object[]{parameters})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractThrowableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractThrowableAssert hasMessage(..)"), new UsesMethod("java.lang.String format(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractThrowableAssertWithFailMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJThrowingCallableRules.AbstractThrowableAssertWithFailMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractThrowableAssertWithFailMessage {\n    \n    @BeforeTemplate\n    AbstractThrowableAssert<?, ? extends Throwable> before(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, @Repeated\n    Object args) {\n        return abstractThrowableAssert.withFailMessage(String.format(message, args));\n    }\n    \n    @AfterTemplate\n    AbstractThrowableAssert<?, ? extends Throwable> after(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, @Repeated\n    Object args) {\n        return abstractThrowableAssert.withFailMessage(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (abstractThrowableAssert, message, args) -> abstractThrowableAssert.withFailMessage(String.format(message, args), new Object[0])).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (abstractThrowableAssert, message, args) -> abstractThrowableAssert.withFailMessage(message, new Object[]{args})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractThrowableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractAssert withFailMessage(..)"), new UsesMethod("java.lang.String format(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

