/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.mockito.Mockito;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MockitoRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to Mockito expressions and statements";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.MockitoRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new NeverRecipe(), new InvocationOnMockGetArgumentsRecipe()});
    }

    @NonNullApi
    public static class NeverRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Mockito#never()`} over explicitly specifying that the associated invocation must happen precisely zero times";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Never {\n    \n    @BeforeTemplate\n    VerificationMode before() {\n        return times(0);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    VerificationMode after() {\n        return never();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", () -> Mockito.times((int)0)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", () -> Mockito.never()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.mockito.Mockito.times");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.mockito.verification.VerificationMode", Boolean.valueOf(true)), new UsesMethod("org.mockito.Mockito times(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class InvocationOnMockGetArgumentsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `MockitoRules.InvocationOnMockGetArguments`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class InvocationOnMockGetArguments {\n    \n    @BeforeTemplate\n    Object before(InvocationOnMock invocation, int i) {\n        return invocation.getArguments()[i];\n    }\n    \n    @AfterTemplate\n    Object after(InvocationOnMock invocation, int i) {\n        return invocation.getArgument(i);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (invocation, i) -> invocation.getArguments()[i]).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (invocation, i) -> invocation.getArgument(i.intValue())).build();

                public J visitExpression(Expression elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitExpression(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.mockito.invocation.InvocationOnMock", Boolean.valueOf(true)), new UsesMethod("org.mockito.invocation.InvocationOnMock getArguments(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

