/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.fixes.SuggestedFix;
import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class SuggestedFixRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `SuggestedFix`es";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.SuggestedFixRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new SuggestedFixDeleteRecipe(), new SuggestedFixReplaceTreeRecipe(), new SuggestedFixReplaceStartEndRecipe(), new SuggestedFixReplaceTreeStartEndRecipe(), new SuggestedFixSwapRecipe(), new SuggestedFixPrefixWithRecipe(), new SuggestedFixPostfixWithRecipe()});
    }

    @NonNullApi
    public static class SuggestedFixDeleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#delete(Tree)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixDelete {\n    \n    @BeforeTemplate\n    SuggestedFix before(Tree tree) {\n        return SuggestedFix.builder().delete(tree).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(Tree tree) {\n        return SuggestedFix.delete(tree);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", tree -> SuggestedFix.builder().delete(tree).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", tree -> SuggestedFix.delete((Tree)tree)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder delete(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SuggestedFixReplaceTreeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#replace(Tree, String)`} over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixReplaceTree {\n    \n    @BeforeTemplate\n    SuggestedFix before(Tree tree, String replaceWith) {\n        return SuggestedFix.builder().replace(tree, replaceWith).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(Tree tree, String replaceWith) {\n        return SuggestedFix.replace(tree, replaceWith);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (tree, replaceWith) -> SuggestedFix.builder().replace(tree, replaceWith).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (tree, replaceWith) -> SuggestedFix.replace((Tree)tree, (String)replaceWith)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SuggestedFixReplaceStartEndRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#replace(int, int, String)`} over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixReplaceStartEnd {\n    \n    @BeforeTemplate\n    SuggestedFix before(int start, int end, String replaceWith) {\n        return SuggestedFix.builder().replace(start, end, replaceWith).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(int start, int end, String replaceWith) {\n        return SuggestedFix.replace(start, end, replaceWith);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (start, end, replaceWith) -> SuggestedFix.builder().replace(start.intValue(), end.intValue(), replaceWith).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (start, end, replaceWith) -> SuggestedFix.replace((int)start, (int)end, (String)replaceWith)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SuggestedFixReplaceTreeStartEndRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#replace(Tree, String, int, int)`} over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixReplaceTreeStartEnd {\n    \n    @BeforeTemplate\n    SuggestedFix before(Tree tree, String replaceWith, int start, int end) {\n        return SuggestedFix.builder().replace(tree, replaceWith, start, end).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(Tree tree, String replaceWith, int start, int end) {\n        return SuggestedFix.replace(tree, replaceWith, start, end);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (tree, replaceWith, start, end) -> SuggestedFix.builder().replace(tree, replaceWith, start.intValue(), end.intValue()).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (tree, replaceWith, start, end) -> SuggestedFix.replace((Tree)tree, (String)replaceWith, (int)start, (int)end)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder replace(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SuggestedFixSwapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#swap(Tree, Tree)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixSwap {\n    \n    @BeforeTemplate\n    SuggestedFix before(Tree tree1, Tree tree2) {\n        return SuggestedFix.builder().swap(tree1, tree2).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(Tree tree1, Tree tree2) {\n        return SuggestedFix.swap(tree1, tree2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (tree1, tree2) -> SuggestedFix.builder().swap(tree1, tree2).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (tree1, tree2) -> SuggestedFix.swap((Tree)tree1, (Tree)tree2)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder swap(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SuggestedFixPrefixWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#prefixWith(Tree, String)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixPrefixWith {\n    \n    @BeforeTemplate\n    SuggestedFix before(Tree tree, String prefix) {\n        return SuggestedFix.builder().prefixWith(tree, prefix).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(Tree tree, String prefix) {\n        return SuggestedFix.prefixWith(tree, prefix);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (tree, prefix) -> SuggestedFix.builder().prefixWith(tree, prefix).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (tree, prefix) -> SuggestedFix.prefixWith((Tree)tree, (String)prefix)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder prefixWith(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class SuggestedFixPostfixWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `SuggestedFix#postfixWith(Tree, String)`} over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SuggestedFixPostfixWith {\n    \n    @BeforeTemplate\n    SuggestedFix before(Tree tree, String postfix) {\n        return SuggestedFix.builder().postfixWith(tree, postfix).build();\n    }\n    \n    @AfterTemplate\n    SuggestedFix after(Tree tree, String postfix) {\n        return SuggestedFix.postfixWith(tree, postfix);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (tree, postfix) -> SuggestedFix.builder().postfixWith(tree, postfix).build()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (tree, postfix) -> SuggestedFix.postfixWith((Tree)tree, (String)postfix)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.fixes.SuggestedFix", Boolean.valueOf(true)), new UsesType("com.sun.source.tree.Tree", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder build(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix.Builder postfixWith(..)"), new UsesMethod("com.google.errorprone.fixes.SuggestedFix builder(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

