/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeAnnotations;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Sort annotations lexicographically where possible", link="https://error-prone.picnic.tech/bugpatterns/LexicographicalAnnotationListing", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class LexicographicalAnnotationListing
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Comparator< @Nullable TypeAnnotations.AnnotationType> BY_ANNOTATION_TYPE = (a, b) -> (a == null || a == TypeAnnotations.AnnotationType.DECLARATION) && b == TypeAnnotations.AnnotationType.TYPE ? -1 : (a == TypeAnnotations.AnnotationType.TYPE && b == TypeAnnotations.AnnotationType.DECLARATION ? 1 : 0);

    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<? extends AnnotationTree> originalOrdering = tree.getModifiers().getAnnotations();
        if (originalOrdering.size() < 2) {
            return Description.NO_MATCH;
        }
        ImmutableList<? extends AnnotationTree> sortedAnnotations = LexicographicalAnnotationListing.sort(originalOrdering, ASTHelpers.getSymbol((MethodTree)tree), state);
        if (originalOrdering.equals(sortedAnnotations)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(originalOrdering.get(0), LexicographicalAnnotationListing.fixOrdering(originalOrdering, sortedAnnotations, state));
    }

    private static ImmutableList<? extends AnnotationTree> sort(List<? extends AnnotationTree> annotations, Symbol symbol, VisitorState state) {
        return (ImmutableList)annotations.stream().sorted(Comparator.comparing(annotation -> ASTHelpers.getAnnotationType((AnnotationTree)annotation, (Symbol)symbol, (VisitorState)state), BY_ANNOTATION_TYPE).thenComparing(annotation -> SourceCode.treeToString((Tree)annotation, (VisitorState)state))).collect(ImmutableList.toImmutableList());
    }

    private static Fix fixOrdering(List<? extends AnnotationTree> originalAnnotations, ImmutableList<? extends AnnotationTree> sortedAnnotations, VisitorState state) {
        return (Fix)Streams.zip(originalAnnotations.stream(), (Stream)sortedAnnotations.stream(), (original, replacement) -> SuggestedFix.builder().replace((Tree)original, SourceCode.treeToString((Tree)replacement, (VisitorState)state))).reduce(SuggestedFix.Builder::merge).map(SuggestedFix.Builder::build).orElseThrow(() -> new VerifyException("No annotations were provided"));
    }
}

