/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel30.xml;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class CircuitBreakerXmlDslRecipe
extends Recipe {
    private static final String RESILIENCE4J_XPATH = "*/circuitBreaker/resilience4jConfiguration";
    private static final XPathMatcher RESILIENCE4J_MATCHER = new XPathMatcher("*/circuitBreaker/resilience4jConfiguration");
    private static final Map<String, XPathMatcher> ATTRIBUTE_MATCHERS = Stream.of("bulkheadEnabled", "bulkheadMaxConcurrentCalls", "bulkheadMaxWaitDuration", "timeoutEnabled", "timeoutExecutorService", "timeoutDuration", "timeoutCancelRunningFuture").collect(Collectors.toMap(k -> k, k -> new XPathMatcher("*/circuitBreaker/resilience4jConfiguration/" + k), (v1, v2) -> v1));

    public String getDisplayName() {
        return "Camel XMl DSL Circuit Breaker changes";
    }

    public String getDescription() {
        return "Apache Camel XML DSL Circuit Breaker migration from version 3.20 or higher to 4.0.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Map values;
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (RESILIENCE4J_MATCHER.matches(this.getCursor()) && (values = (Map)ctx.pollMessage(CircuitBreakerXmlDslRecipe.RESILIENCE4J_XPATH)) != null && !values.isEmpty()) {
                    List toAdd = values.entrySet().stream().map(e -> (Xml.Attribute)this.autoFormat((Xml)new Xml.Attribute(Tree.randomId(), "", Markers.EMPTY, new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, (String)e.getKey()), "", (Xml.Attribute.Value)this.autoFormat((Xml)new Xml.Attribute.Value(Tree.randomId(), "", Markers.EMPTY, Xml.Attribute.Value.Quote.Double, (String)e.getValue()), ctx)), ctx)).collect(Collectors.toList());
                    return t.withAttributes(ListUtils.concatAll((List)t.getAttributes(), toAdd));
                }
                for (Map.Entry<String, XPathMatcher> entry : ATTRIBUTE_MATCHERS.entrySet()) {
                    if (!entry.getValue().matches(this.getCursor())) continue;
                    if (t.getValue().isPresent() && !((String)t.getValue().get()).isEmpty()) {
                        Map values2 = (Map)ctx.getMessage(CircuitBreakerXmlDslRecipe.RESILIENCE4J_XPATH, new LinkedHashMap());
                        values2.put(entry.getKey(), (String)t.getValue().get());
                        ctx.putMessage(CircuitBreakerXmlDslRecipe.RESILIENCE4J_XPATH, (Object)values2);
                    }
                    return null;
                }
                return t;
            }
        };
    }
}

