/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJByteRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJByteRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJByteRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJByteRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractByteAssertIsEqualToRecipe(), new AbstractByteAssertIsNotEqualToRecipe(), new AbstractByteAssertIsZeroRecipe(), new AbstractByteAssertIsNotZeroRecipe(), new AbstractByteAssertIsOneRecipe()});
    }

    @NonNullApi
    public static class AbstractByteAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert, byte n) {\n        return Refaster.anyOf(byteAssert.isCloseTo(n, offset((byte)0)), byteAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert, byte n) {\n        return byteAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isCloseTo(#{n:any(byte)}, org.assertj.core.data.Offset.offset((byte)0))").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isCloseTo(#{n:any(byte)}, org.assertj.core.data.Percentage.withPercentage(0))").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo(#{n:any(byte)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isCloseTo(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)"), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractByteAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert, byte n) {\n        return Refaster.anyOf(byteAssert.isNotCloseTo(n, offset((byte)0)), byteAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert, byte n) {\n        return byteAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotCloseTo(#{n:any(byte)}, org.assertj.core.data.Offset.offset((byte)0))").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotCloseTo(#{n:any(byte)}, org.assertj.core.data.Percentage.withPercentage(0))").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotEqualTo(#{n:any(byte)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isNotCloseTo(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)"), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractByteAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isEqualTo((byte)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isZero()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo((byte)0)").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractByteAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isNotEqualTo((byte)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotZero()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isNotEqualTo((byte)0)").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isNotZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractByteAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isEqualTo((byte)1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isOne()").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{byteAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isEqualTo((byte)1)").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isOne(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

