/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;

final class ImmutableSortedMultisetRules {
    private ImmutableSortedMultisetRules() {
    }

    static final class StreamToImmutableSortedMultiset<T extends Comparable<? super T>> {
        StreamToImmutableSortedMultiset() {
        }

        ImmutableSortedMultiset<T> before(Stream<T> stream) {
            return ImmutableSortedMultiset.copyOf(stream.iterator());
        }

        ImmutableSortedMultiset<T> after(Stream<T> stream) {
            return (ImmutableSortedMultiset)stream.collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder()));
        }
    }

    static final class IterableToImmutableSortedMultiset<T extends Comparable<? super T>> {
        IterableToImmutableSortedMultiset() {
        }

        ImmutableSortedMultiset<T> before(T[] iterable) {
            return (ImmutableSortedMultiset)Refaster.anyOf((Object[])new ImmutableSortedMultiset[]{ImmutableSortedMultiset.naturalOrder().add((Object[])iterable).build(), (ImmutableSortedMultiset)Arrays.stream(iterable).collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder()))});
        }

        ImmutableSortedMultiset<T> before(Iterator<T> iterable) {
            return (ImmutableSortedMultiset)Refaster.anyOf((Object[])new ImmutableSortedMultiset[]{ImmutableSortedMultiset.copyOf(Comparator.naturalOrder(), iterable), ImmutableSortedMultiset.naturalOrder().addAll(iterable).build(), (ImmutableSortedMultiset)Streams.stream(iterable).collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder()))});
        }

        ImmutableSortedMultiset<T> before(Iterable<T> iterable) {
            return (ImmutableSortedMultiset)Refaster.anyOf((Object[])new ImmutableSortedMultiset[]{ImmutableSortedMultiset.copyOf(Comparator.naturalOrder(), iterable), ImmutableSortedMultiset.naturalOrder().addAll(iterable).build(), (ImmutableSortedMultiset)Streams.stream(iterable).collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder()))});
        }

        ImmutableSortedMultiset<T> before(Collection<T> iterable) {
            return (ImmutableSortedMultiset)iterable.stream().collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder()));
        }

        ImmutableSortedMultiset<T> after(Iterable<T> iterable) {
            return ImmutableSortedMultiset.copyOf(iterable);
        }
    }

    static final class EmptyImmutableSortedMultiset<T extends Comparable<? super T>> {
        EmptyImmutableSortedMultiset() {
        }

        ImmutableSortedMultiset<T> before() {
            return (ImmutableSortedMultiset)Refaster.anyOf((Object[])new ImmutableSortedMultiset[]{ImmutableSortedMultiset.naturalOrder().build(), (ImmutableSortedMultiset)Stream.empty().collect(ImmutableSortedMultiset.toImmutableSortedMultiset(Comparator.naturalOrder()))});
        }

        ImmutableSortedMultiset<T> after() {
            return ImmutableSortedMultiset.of();
        }
    }

    static final class ImmutableSortedMultisetReverseOrderBuilder<T extends Comparable<? super T>> {
        ImmutableSortedMultisetReverseOrderBuilder() {
        }

        ImmutableSortedMultiset.Builder<T> before() {
            return ImmutableSortedMultiset.orderedBy(Comparator.reverseOrder());
        }

        ImmutableSortedMultiset.Builder<T> after() {
            return ImmutableSortedMultiset.reverseOrder();
        }
    }

    static final class ImmutableSortedMultisetNaturalOrderBuilder<T extends Comparable<? super T>> {
        ImmutableSortedMultisetNaturalOrderBuilder() {
        }

        ImmutableSortedMultiset.Builder<T> before() {
            return ImmutableSortedMultiset.orderedBy(Comparator.naturalOrder());
        }

        ImmutableSortedMultiset.Builder<T> after() {
            return ImmutableSortedMultiset.naturalOrder();
        }
    }

    static final class ImmutableSortedMultisetBuilder<T> {
        ImmutableSortedMultisetBuilder() {
        }

        ImmutableSortedMultiset.Builder<T> before(Comparator<T> cmp) {
            return new ImmutableSortedMultiset.Builder(cmp);
        }

        ImmutableSortedMultiset.Builder<T> after(Comparator<T> cmp) {
            return ImmutableSortedMultiset.orderedBy(cmp);
        }
    }
}

