/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class IntStreamRules {
    private IntStreamRules() {
    }

    static final class IntStreamTakeWhile {
        IntStreamTakeWhile() {
        }

        IntStream before(IntStream stream, IntPredicate predicate) {
            return stream.takeWhile(predicate).filter(predicate);
        }

        IntStream after(IntStream stream, IntPredicate predicate) {
            return stream.takeWhile(predicate);
        }
    }

    static abstract class IntStreamAllMatch2 {
        IntStreamAllMatch2() {
        }

        abstract boolean test(int var1);

        boolean before(IntStream stream) {
            return stream.noneMatch(e -> !this.test(e));
        }

        boolean after(IntStream stream) {
            return stream.allMatch(e -> this.test(e));
        }
    }

    static final class IntStreamAllMatch {
        IntStreamAllMatch() {
        }

        boolean before(IntStream stream, IntPredicate predicate) {
            return stream.noneMatch(predicate.negate());
        }

        boolean after(IntStream stream, IntPredicate predicate) {
            return stream.allMatch(predicate);
        }
    }

    static final class IntStreamAnyMatch {
        IntStreamAnyMatch() {
        }

        boolean before(IntStream stream, IntPredicate predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.noneMatch(predicate), stream.filter(predicate).findAny().isPresent()});
        }

        boolean after(IntStream stream, IntPredicate predicate) {
            return stream.anyMatch(predicate);
        }
    }

    static abstract class IntStreamNoneMatch2 {
        IntStreamNoneMatch2() {
        }

        abstract boolean test(int var1);

        boolean before(IntStream stream) {
            return stream.allMatch(e -> !this.test(e));
        }

        boolean after(IntStream stream) {
            return stream.noneMatch(e -> this.test(e));
        }
    }

    static final class IntStreamNoneMatch {
        IntStreamNoneMatch() {
        }

        boolean before(IntStream stream, IntPredicate predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.anyMatch(predicate), stream.allMatch(predicate.negate()), stream.filter(predicate).findAny().isEmpty()});
        }

        boolean after(IntStream stream, IntPredicate predicate) {
            return stream.noneMatch(predicate);
        }
    }

    static final class IntStreamMin {
        IntStreamMin() {
        }

        OptionalInt before(IntStream stream) {
            return stream.sorted().findFirst();
        }

        OptionalInt after(IntStream stream) {
            return stream.min();
        }
    }

    static final class IntStreamIsNotEmpty {
        IntStreamIsNotEmpty() {
        }

        boolean before(IntStream stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() != 0L, stream.count() > 0L, stream.count() >= 1L, stream.findFirst().isPresent()});
        }

        boolean after(IntStream stream) {
            return stream.findAny().isPresent();
        }
    }

    static final class IntStreamIsEmpty {
        IntStreamIsEmpty() {
        }

        boolean before(IntStream stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() == 0L, stream.count() <= 0L, stream.count() < 1L, stream.findFirst().isEmpty()});
        }

        boolean after(IntStream stream) {
            return stream.findAny().isEmpty();
        }
    }

    static final class IntStreamFilterSorted {
        IntStreamFilterSorted() {
        }

        IntStream before(IntStream stream, IntPredicate predicate) {
            return stream.sorted().filter(predicate);
        }

        IntStream after(IntStream stream, IntPredicate predicate) {
            return stream.filter(predicate).sorted();
        }
    }

    static abstract class FlatMapOuterStreamAfterFlatMapToInt<T> {
        FlatMapOuterStreamAfterFlatMapToInt() {
        }

        abstract IntStream toIntStreamFunction(T var1);

        IntStream before(Stream<T> stream, IntFunction<? extends IntStream> function) {
            return stream.flatMapToInt(v -> this.toIntStreamFunction(v).flatMap(function));
        }

        IntStream after(Stream<T> stream, IntFunction<? extends IntStream> function) {
            return stream.flatMapToInt(v -> this.toIntStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class FlatMapOuterIntStreamAfterFlatMap {
        FlatMapOuterIntStreamAfterFlatMap() {
        }

        abstract IntStream toIntStreamFunction(int var1);

        IntStream before(IntStream stream, IntFunction<? extends IntStream> function) {
            return stream.flatMap(v -> this.toIntStreamFunction(v).flatMap(function));
        }

        IntStream after(IntStream stream, IntFunction<? extends IntStream> function) {
            return stream.flatMap(v -> this.toIntStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class MapOuterStreamAfterFlatMapToInt<T> {
        MapOuterStreamAfterFlatMapToInt() {
        }

        abstract IntStream toIntStreamFunction(T var1);

        IntStream before(Stream<T> stream, IntUnaryOperator function) {
            return stream.flatMapToInt(v -> this.toIntStreamFunction(v).map(function));
        }

        IntStream after(Stream<T> stream, IntUnaryOperator function) {
            return stream.flatMapToInt(v -> this.toIntStreamFunction(v)).map(function);
        }
    }

    static abstract class MapOuterIntStreamAfterFlatMap {
        MapOuterIntStreamAfterFlatMap() {
        }

        abstract IntStream toIntStreamFunction(int var1);

        IntStream before(IntStream stream, IntUnaryOperator function) {
            return stream.flatMap(v -> this.toIntStreamFunction(v).map(function));
        }

        IntStream after(IntStream stream, IntUnaryOperator function) {
            return stream.flatMap(v -> this.toIntStreamFunction(v)).map(function);
        }
    }

    static abstract class FilterOuterStreamAfterFlatMapToInt<T> {
        FilterOuterStreamAfterFlatMapToInt() {
        }

        abstract IntStream toIntStreamFunction(T var1);

        IntStream before(Stream<T> stream, IntPredicate predicate) {
            return stream.flatMapToInt(v -> this.toIntStreamFunction(v).filter(predicate));
        }

        IntStream after(Stream<T> stream, IntPredicate predicate) {
            return stream.flatMapToInt(v -> this.toIntStreamFunction(v)).filter(predicate);
        }
    }

    static abstract class FilterOuterIntStreamAfterFlatMap {
        FilterOuterIntStreamAfterFlatMap() {
        }

        abstract IntStream toIntStreamFunction(int var1);

        IntStream before(IntStream stream, IntPredicate predicate) {
            return stream.flatMap(v -> this.toIntStreamFunction(v).filter(predicate));
        }

        IntStream after(IntStream stream, IntPredicate predicate) {
            return stream.flatMap(v -> this.toIntStreamFunction(v)).filter(predicate);
        }
    }

    static final class ConcatTwoIntStreams {
        ConcatTwoIntStreams() {
        }

        IntStream before(IntStream s1, IntStream s2) {
            return Streams.concat((IntStream[])new IntStream[]{s1, s2});
        }

        IntStream after(IntStream s1, IntStream s2) {
            return IntStream.concat(s1, s2);
        }
    }

    static final class ConcatOneIntStream {
        ConcatOneIntStream() {
        }

        IntStream before(IntStream stream) {
            return Streams.concat((IntStream[])new IntStream[]{stream});
        }

        @CanIgnoreReturnValue
        IntStream after(IntStream stream) {
            return stream;
        }
    }

    static final class IntStreamClosedOpenRange {
        IntStreamClosedOpenRange() {
        }

        IntStream before(int from, int to) {
            return IntStream.rangeClosed(from, to - 1);
        }

        IntStream after(int from, int to) {
            return IntStream.range(from, to);
        }
    }
}

