/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

final class MultimapRules {
    private MultimapRules() {
    }

    static final class MultimapValuesStream<K, V> {
        MultimapValuesStream() {
        }

        Stream<V> before(Multimap<K, V> multimap) {
            return multimap.entries().stream().map(Map.Entry::getValue);
        }

        Stream<V> after(Multimap<K, V> multimap) {
            return multimap.values().stream();
        }
    }

    static final class MultimapKeysStream<K, V> {
        MultimapKeysStream() {
        }

        Stream<K> before(Multimap<K, V> multimap) {
            return multimap.entries().stream().map(Map.Entry::getKey);
        }

        Stream<K> after(Multimap<K, V> multimap) {
            return multimap.keys().stream();
        }
    }

    static final class MultimapGet<K, V> {
        MultimapGet() {
        }

        @Nullable Collection<V> before(Multimap<K, V> multimap, K key) {
            return (Collection)((Map)Refaster.anyOf((Object[])new Map[]{multimap.asMap(), Multimaps.asMap(multimap)})).get(key);
        }

        Collection<V> after(Multimap<K, V> multimap, K key) {
            return multimap.get(key);
        }
    }

    static final class MultimapContainsValue<K, V, T> {
        MultimapContainsValue() {
        }

        boolean before(Multimap<K, V> multimap, T value) {
            return multimap.values().contains(value);
        }

        boolean after(Multimap<K, V> multimap, T value) {
            return multimap.containsValue(value);
        }
    }

    static final class MultimapContainsKey<K, V, T> {
        MultimapContainsKey() {
        }

        boolean before(Multimap<K, V> multimap, T key) {
            return ((Collection)Refaster.anyOf((Object[])new Collection[]{multimap.keySet(), multimap.keys()})).contains(key);
        }

        boolean after(Multimap<K, V> multimap, T key) {
            return multimap.containsKey(key);
        }
    }

    static final class MultimapSize<K, V> {
        MultimapSize() {
        }

        int before(Multimap<K, V> multimap) {
            return multimap.values().size();
        }

        int after(Multimap<K, V> multimap) {
            return multimap.size();
        }
    }

    static final class MultimapIsEmpty<K, V> {
        MultimapIsEmpty() {
        }

        boolean before(Multimap<K, V> multimap) {
            return ((Collection)Refaster.anyOf((Object[])new Collection[]{multimap.keySet(), multimap.keys(), multimap.values(), multimap.entries()})).isEmpty();
        }

        boolean after(Multimap<K, V> multimap) {
            return multimap.isEmpty();
        }
    }

    static final class MultimapKeySet<K, V> {
        MultimapKeySet() {
        }

        Set<K> before(Multimap<K, V> multimap) {
            return multimap.asMap().keySet();
        }

        Set<K> after(Multimap<K, V> multimap) {
            return multimap.keySet();
        }
    }
}

