/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class BugCheckerRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to `com.google.errorprone.bugpatterns.BugChecker` classes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.BugCheckerRules`. [Source](https://error-prone.picnic.tech/refasterrules/BugCheckerRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BugCheckerRefactoringTestHelperIdentityRecipe(), new BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe(), new ConstantsFormatRecipe(), new NameContentEqualsRecipe()});
    }

    @NullMarked
    public static class BugCheckerRefactoringTestHelperIdentityRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid calling `BugCheckerRefactoringTestHelper#setFixChooser(FixChooser)` or `BugCheckerRefactoringTestHelper#setImportOrder(String)` with their respective default values";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BugCheckerRefactoringTestHelperIdentity {\n    \n    @BeforeTemplate\n    BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper) {\n        return Refaster.anyOf(helper.setFixChooser(FixChoosers.FIRST), helper.setImportOrder(\"static-first\"));\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper) {\n        return helper;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setFixChooser(com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers.FIRST)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.setImportOrder(\"static-first\")").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper.FixChoosers", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper setFixChooser(..)", true)}), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper setImportOrder(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `BugCheckerRefactoringTestHelper.ExpectOutput#expectUnchanged()` over repeating the input";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged {\n    \n    @BeforeTemplate\n    BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper, String path, String source) {\n        return helper.addInputLines(path, source).addOutputLines(path, source);\n    }\n    \n    @AfterTemplate\n    BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper, String path, String source) {\n        return helper.addInputLines(path, source).expectUnchanged();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).addOutputLines(#{path}, #{source})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{helper:any(com.google.errorprone.BugCheckerRefactoringTestHelper)}.addInputLines(#{path:any(java.lang.String)}, #{source:any(java.lang.String)}).expectUnchanged()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput addOutputLines(..)", true), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper addInputLines(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConstantsFormatRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using the `Constants` API over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConstantsFormat {\n    \n    @BeforeTemplate\n    String before(String value) {\n        return String.format(\"\\\"%s\\\"\", Convert.quote(value));\n    }\n    \n    @AfterTemplate\n    String after(String value) {\n        return Constants.format(value);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"String.format(\"\\\"%s\\\"\", com.sun.tools.javac.util.Convert.quote(#{value:any(java.lang.String)}))").build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.sun.tools.javac.util.Constants.format(#{value:any(java.lang.String)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.sun.tools.javac.util.Convert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.sun.tools.javac.util.Convert", Boolean.valueOf(true)), new UsesMethod("java.lang.String format(..)", true), new UsesMethod("com.sun.tools.javac.util.Convert quote(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NameContentEqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Name#contentEquals(CharSequence)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NameContentEquals {\n    \n    @BeforeTemplate\n    boolean before(Name name, CharSequence string) {\n        return name.toString().equals(string.toString());\n    }\n    \n    @BeforeTemplate\n    boolean before(Name name, String string) {\n        return name.toString().equals(string);\n    }\n    \n    @AfterTemplate\n    boolean after(Name name, CharSequence string) {\n        return name.contentEquals(string);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.CharSequence)}.toString())").build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.toString().equals(#{string:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{name:any(javax.lang.model.element.Name)}.contentEquals(#{string:any(java.lang.CharSequence)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.lang.model.element.Name", Boolean.valueOf(true)), new UsesMethod("java.lang.String equals(..)", true), new UsesMethod("java.lang.CharSequence toString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

