/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class StringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `String`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.StringRules`. [Source](https://error-prone.picnic.tech/refasterrules/StringRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new StringIsEmptyRecipe(), new StringIsNullOrEmptyRecipe(), new OptionalNonEmptyStringRecipe(), new FilterEmptyStringRecipe(), new JoinStringsRecipe(), new StringValueOfRecipe(), new NewStringFromCharArraySubSequenceRecipe(), new NewStringFromCharArrayRecipe(), new SubstringRemainderRecipe(), new Utf8EncodedLengthRecipe(), new StringIndexOfCharRecipe(), new StringIndexOfStringRecipe(), new StringLastIndexOfCharRecipe(), new StringLastIndexOfStringRecipe(), new StringLastIndexOfCharWithIndexRecipe(), new StringLastIndexOfStringWithIndexRecipe(), new StringStartsWithRecipe()});
    }

    @NullMarked
    public static class StringIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#isEmpty()` over alternatives that consult the string's length";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringIsEmpty {\n    \n    @BeforeTemplate\n    boolean before(String str) {\n        return Refaster.anyOf(str.length() == 0, str.length() <= 0, str.length() < 1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(String str) {\n        return str.isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.length() == 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.length() <= 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.length() < 1").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.isEmpty()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String length(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIsNullOrEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Strings#isNullOrEmpty(String)` over the more verbose alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringIsNullOrEmpty {\n    \n    @BeforeTemplate\n    boolean before(@Nullable\n    String str) {\n        return str == null || str.isEmpty();\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(String str) {\n        return Strings.isNullOrEmpty(str);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{str:any(java.lang.@org.jspecify.annotations.Nullable String)} == null || #{str}.isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.base.Strings.isNullOrEmpty(#{str:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String isEmpty(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalNonEmptyStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't use the ternary operator to create an optionally-absent string";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class OptionalNonEmptyString {\n    \n    @BeforeTemplate\n    Optional<String> before(String str) {\n        return Strings.isNullOrEmpty(str) ? Optional.empty() : Refaster.anyOf(Optional.of(str), Optional.ofNullable(str));\n    }\n    \n    @AfterTemplate\n    Optional<String> after(String str) {\n        return Optional.ofNullable(str).filter(not(String::isEmpty));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"Strings.isNullOrEmpty(str) ? Optional.empty() : java.util.Optional.of(#{str:any(java.lang.String)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"Strings.isNullOrEmpty(str) ? Optional.empty() : java.util.Optional.ofNullable(#{str:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{str:any(java.lang.String)}).filter(java.util.function.Predicate.not(String::isEmpty))").build();

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Strings");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Strings");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Strings", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Strings isNullOrEmpty(..)", true), new UsesMethod("java.util.Optional empty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional of(..)", true), new UsesMethod("java.util.Optional ofNullable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilterEmptyStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `StringRules.FilterEmptyString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilterEmptyString {\n    \n    @BeforeTemplate\n    Optional<String> before(Optional<String> optional) {\n        return optional.map(Strings::emptyToNull);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    Optional<String> after(Optional<String> optional) {\n        return optional.filter(not(String::isEmpty));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<java.lang.String>)}.map(com.google.common.base.Strings::emptyToNull)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{optional:any(java.util.Optional<java.lang.String>)}.filter(java.util.function.Predicate.not(String::isEmpty))").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Strings");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Strings", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional map(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JoinStringsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#join(CharSequence, Iterable)` and variants over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class JoinStrings {\n    \n    @BeforeTemplate\n    String before(String delimiter, CharSequence[] elements) {\n        return Refaster.anyOf(Joiner.on(delimiter).join(elements), Arrays.stream(elements).collect(joining(delimiter)));\n    }\n    \n    @BeforeTemplate\n    String before(String delimiter, Iterable<? extends CharSequence> elements) {\n        return Refaster.anyOf(Joiner.on(delimiter).join(elements), Streams.stream(elements).collect(joining(delimiter)));\n    }\n    \n    @BeforeTemplate\n    String before(CharSequence delimiter, Collection<? extends CharSequence> elements) {\n        return elements.stream().collect(joining(delimiter));\n    }\n    \n    @AfterTemplate\n    String after(CharSequence delimiter, Iterable<? extends CharSequence> elements) {\n        return String.join(delimiter, elements);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.base.Joiner.on(#{delimiter:any(java.lang.String)}).join(#{elements:anyArray(java.lang.CharSequence)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.Arrays.stream(#{elements:anyArray(java.lang.CharSequence)}).collect(java.util.stream.Collectors.joining(#{delimiter:any(java.lang.String)}))").build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"com.google.common.base.Joiner.on(#{delimiter:any(java.lang.String)}).join(#{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)}).collect(java.util.stream.Collectors.joining(#{delimiter:any(java.lang.String)}))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1 = JavaTemplate.builder((String)"#{elements:any(java.util.Collection<? extends java.lang.CharSequence>)}.stream().collect(java.util.stream.Collectors.joining(#{delimiter:any(java.lang.CharSequence)}))").build();
                final JavaTemplate after = JavaTemplate.builder((String)"String.join(#{delimiter:any(java.lang.CharSequence)}, #{elements:any(java.lang.Iterable<? extends java.lang.CharSequence>)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Joiner");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Arrays");
                        this.maybeRemoveImport("java.util.stream.Collectors.joining");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Joiner");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("java.util.stream.Collectors.joining");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("java.util.stream.Collectors.joining");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Joiner", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Joiner join(..)", true), new UsesMethod("com.google.common.base.Joiner on(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Collectors joining(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Collectors joining(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringValueOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer direct invocation of `String#valueOf(Object)` over the indirection introduced by `Objects#toString(Object)`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringValueOf {\n    \n    @BeforeTemplate\n    String before(Object object) {\n        return Objects.toString(object);\n    }\n    \n    @AfterTemplate\n    String after(Object object) {\n        return String.valueOf(object);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.Objects.toString(#{object:any(java.lang.Object)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"String.valueOf(#{object:any(java.lang.Object)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Objects", Boolean.valueOf(true)), new UsesMethod("java.util.Objects toString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NewStringFromCharArraySubSequenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer direct invocation of `String#String(char[], int, int)` over the indirection introduced by alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NewStringFromCharArraySubSequence {\n    \n    @BeforeTemplate\n    String before(char[] data, int offset, int count) {\n        return Refaster.anyOf(String.valueOf(data, offset, count), String.copyValueOf(data, offset, count));\n    }\n    \n    @AfterTemplate\n    String after(char[] data, int offset, int count) {\n        return new String(data, offset, count);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"String.valueOf(#{data:anyArray(char)}, #{offset:any(int)}, #{count:any(int)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"String.copyValueOf(#{data:anyArray(char)}, #{offset:any(int)}, #{count:any(int)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"new String(#{data:anyArray(char)}, #{offset:any(int)}, #{count:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String valueOf(..)", true), new UsesMethod("java.lang.String copyValueOf(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NewStringFromCharArrayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer direct invocation of `String#String(char[])` over the indirection introduced by alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NewStringFromCharArray {\n    \n    @BeforeTemplate\n    String before(char[] data) {\n        return Refaster.anyOf(String.valueOf(data), new String(data, 0, data.length));\n    }\n    \n    @AfterTemplate\n    String after(char[] data) {\n        return new String(data);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"String.valueOf(#{data:anyArray(char)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"new String(#{data:anyArray(char)}, 0, #{data}.length)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"new String(#{data:anyArray(char)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String valueOf(..)", true), new UsesMethod("java.lang.String <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SubstringRemainderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily use the two-argument `String#substring(int, int)`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class SubstringRemainder {\n    \n    @BeforeTemplate\n    String before(String str, int index) {\n        return str.substring(index, str.length());\n    }\n    \n    @AfterTemplate\n    String after(String str, int index) {\n        return str.substring(index);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.substring(#{index:any(int)}, #{str}.length())").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.substring(#{index:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String substring(..)", true), new UsesMethod("java.lang.String length(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class Utf8EncodedLengthRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Utf8#encodedLength(CharSequence)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class Utf8EncodedLength {\n    \n    @BeforeTemplate\n    int before(String str) {\n        return str.getBytes(UTF_8).length;\n    }\n    \n    @AfterTemplate\n    int after(String str) {\n        return Utf8.encodedLength(str);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{str:any(java.lang.String)}.getBytes(java.nio.charset.StandardCharsets.UTF_8).length").build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.base.Utf8.encodedLength(#{str:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String getBytes(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIndexOfCharRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#indexOf(int, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringIndexOfChar {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4635\")\n    int before(String string, int ch, int fromIndex) {\n        return string.substring(fromIndex).indexOf(ch);\n    }\n    \n    @AfterTemplate\n    int after(String string, int ch, int fromIndex) {\n        return Math.max(-1, string.indexOf(ch, fromIndex) - fromIndex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).indexOf(#{ch:any(int)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.indexOf(#{ch:any(int)}, #{fromIndex:any(int)}) - #{fromIndex})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String indexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringIndexOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#indexOf(String, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringIndexOfString {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4635\")\n    int before(String string, String substring, int fromIndex) {\n        return string.substring(fromIndex).indexOf(substring);\n    }\n    \n    @AfterTemplate\n    int after(String string, String substring, int fromIndex) {\n        return Math.max(-1, string.indexOf(substring, fromIndex) - fromIndex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).indexOf(#{substring:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.indexOf(#{substring:any(java.lang.String)}, #{fromIndex:any(int)}) - #{fromIndex})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String indexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfCharRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#lastIndexOf(int, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringLastIndexOfChar {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4635\")\n    int before(String string, int ch, int fromIndex) {\n        return string.substring(fromIndex).lastIndexOf(ch);\n    }\n    \n    @AfterTemplate\n    int after(String string, int ch, int fromIndex) {\n        return Math.max(-1, string.lastIndexOf(ch) - fromIndex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).lastIndexOf(#{ch:any(int)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.lastIndexOf(#{ch:any(int)}) - #{fromIndex:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#lastIndexOf(String, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringLastIndexOfString {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4635\")\n    int before(String string, String substring, int fromIndex) {\n        return string.substring(fromIndex).lastIndexOf(substring);\n    }\n    \n    @AfterTemplate\n    int after(String string, String substring, int fromIndex) {\n        return Math.max(-1, string.lastIndexOf(substring) - fromIndex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).lastIndexOf(#{substring:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Math.max(-1, #{string:any(java.lang.String)}.lastIndexOf(#{substring:any(java.lang.String)}) - #{fromIndex:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfCharWithIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#lastIndexOf(int, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringLastIndexOfCharWithIndex {\n    \n    @BeforeTemplate\n    int before(String string, int ch, int fromIndex) {\n        return string.substring(0, fromIndex).lastIndexOf(ch);\n    }\n    \n    @AfterTemplate\n    int after(String string, int ch, int fromIndex) {\n        return string.lastIndexOf(ch, fromIndex - 1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(0, #{fromIndex:any(int)}).lastIndexOf(#{ch:any(int)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.lastIndexOf(#{ch:any(int)}, #{fromIndex:any(int)} - 1)").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringLastIndexOfStringWithIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#lastIndexOf(String, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringLastIndexOfStringWithIndex {\n    \n    @BeforeTemplate\n    int before(String string, String substring, int fromIndex) {\n        return string.substring(0, fromIndex).lastIndexOf(substring);\n    }\n    \n    @AfterTemplate\n    int after(String string, String substring, int fromIndex) {\n        return string.lastIndexOf(substring, fromIndex - 1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(0, #{fromIndex:any(int)}).lastIndexOf(#{substring:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.lastIndexOf(#{substring:any(java.lang.String)}, #{fromIndex:any(int)} - 1)").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String lastIndexOf(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StringStartsWithRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `String#startsWith(String, int)` over less efficient alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StringStartsWith {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4635\")\n    boolean before(String string, String prefix, int fromIndex) {\n        return string.substring(fromIndex).startsWith(prefix);\n    }\n    \n    @AfterTemplate\n    boolean after(String string, String prefix, int fromIndex) {\n        return string.startsWith(prefix, fromIndex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.substring(#{fromIndex:any(int)}).startsWith(#{prefix:any(java.lang.String)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{string:any(java.lang.String)}.startsWith(#{prefix:any(java.lang.String)}, #{fromIndex:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.String startsWith(..)", true), new UsesMethod("java.lang.String substring(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

