/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJNumberRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJNumberRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJNumberRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJNumberRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new NumberAssertIsPositiveRecipe(), new NumberAssertIsNotPositiveRecipe(), new NumberAssertIsNegativeRecipe(), new NumberAssertIsNotNegativeRecipe()});
    }

    @NullMarked
    public static class NumberAssertIsPositiveRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsPositive`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsPositive {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan((byte)0), numberAssert.isGreaterThanOrEqualTo((byte)1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan((short)0), numberAssert.isGreaterThanOrEqualTo((short)1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan(0), numberAssert.isGreaterThanOrEqualTo(1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan(0), numberAssert.isGreaterThanOrEqualTo(1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isGreaterThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isGreaterThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThan(BigInteger.ZERO), numberAssert.isGreaterThanOrEqualTo(BigInteger.valueOf(1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isGreaterThan(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isPositive();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThan((byte)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThanOrEqualTo((byte)1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThan((short)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThanOrEqualTo((short)1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThanOrEqualTo(1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThanOrEqualTo(1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isGreaterThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before4 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isGreaterThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThan(java.math.BigInteger.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThanOrEqualTo(java.math.BigInteger.valueOf(1))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before6 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isGreaterThan(java.math.BigDecimal.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isPositive()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigDecimal");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isGreaterThanOrEqualTo(..)", true), new UsesMethod("java.math.BigInteger valueOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigDecimalAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NumberAssertIsNotPositiveRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsNotPositive`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsNotPositive {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo((byte)0), numberAssert.isLessThan((byte)1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo((short)0), numberAssert.isLessThan((short)1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo(0), numberAssert.isLessThan(1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo(0), numberAssert.isLessThan(1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isLessThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isLessThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThanOrEqualTo(BigInteger.ZERO), numberAssert.isLessThan(BigInteger.valueOf(1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isLessThanOrEqualTo(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isNotPositive();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThanOrEqualTo((byte)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThan((byte)1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThanOrEqualTo((short)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThan((short)1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThan(1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThan(1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isLessThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before4 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isLessThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThanOrEqualTo(java.math.BigInteger.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThan(java.math.BigInteger.valueOf(1))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before6 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isLessThanOrEqualTo(java.math.BigDecimal.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isNotPositive()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigDecimal");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isLessThanOrEqualTo(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true), new UsesMethod("java.math.BigInteger valueOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigDecimalAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBigDecimalAssert isLessThanOrEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NumberAssertIsNegativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsNegative`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsNegative {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan((byte)0), numberAssert.isLessThanOrEqualTo((byte)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan((short)0), numberAssert.isLessThanOrEqualTo((short)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan(0), numberAssert.isLessThanOrEqualTo(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan(0), numberAssert.isLessThanOrEqualTo(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isLessThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isLessThan(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isLessThan(BigInteger.ZERO), numberAssert.isLessThanOrEqualTo(BigInteger.valueOf(-1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isLessThan(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isNegative();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThan((byte)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isLessThanOrEqualTo((byte)-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThan((short)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isLessThanOrEqualTo((short)-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isLessThanOrEqualTo(-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isLessThanOrEqualTo(-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isLessThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before4 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isLessThan(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThan(java.math.BigInteger.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isLessThanOrEqualTo(java.math.BigInteger.valueOf(-1))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before6 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isLessThan(java.math.BigDecimal.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isNegative()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigDecimal");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isLessThanOrEqualTo(..)", true), new UsesMethod("java.math.BigInteger valueOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigDecimalAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isLessThan(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NumberAssertIsNotNegativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJNumberRules.NumberAssertIsNotNegative`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class NumberAssertIsNotNegative {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo((byte)0), numberAssert.isGreaterThan((byte)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo((short)0), numberAssert.isGreaterThan((short)-1));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(AbstractIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo(0), numberAssert.isGreaterThan(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(AbstractLongAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo(0), numberAssert.isGreaterThan(-1));\n    }\n    \n    @BeforeTemplate\n    AbstractFloatAssert<?> before(AbstractFloatAssert<?> numberAssert) {\n        return numberAssert.isGreaterThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> numberAssert) {\n        return numberAssert.isGreaterThanOrEqualTo(0);\n    }\n    \n    @BeforeTemplate\n    AbstractBigIntegerAssert<?> before(AbstractBigIntegerAssert<?> numberAssert) {\n        return Refaster.anyOf(numberAssert.isGreaterThanOrEqualTo(BigInteger.ZERO), numberAssert.isGreaterThan(BigInteger.valueOf(-1)));\n    }\n    \n    @BeforeTemplate\n    AbstractBigDecimalAssert<?> before(AbstractBigDecimalAssert<?> numberAssert) {\n        return numberAssert.isGreaterThanOrEqualTo(BigDecimal.ZERO);\n    }\n    \n    @AfterTemplate\n    NumberAssert<?, ?> after(NumberAssert<?, ?> numberAssert) {\n        return numberAssert.isNotNegative();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThanOrEqualTo((byte)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractByteAssert<?>)}.isGreaterThan((byte)-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThanOrEqualTo((short)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isGreaterThan((short)-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractIntegerAssert<?>)}.isGreaterThan(-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isGreaterThan(-1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isGreaterThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before4 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isGreaterThanOrEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$0 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThanOrEqualTo(java.math.BigInteger.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before5$1 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigIntegerAssert<?>)}.isGreaterThan(java.math.BigInteger.valueOf(-1))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before6 = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.AbstractBigDecimalAssert<?>)}.isGreaterThanOrEqualTo(java.math.BigDecimal.ZERO)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{numberAssert:any(org.assertj.core.api.NumberAssert<?,?>)}.isNotNegative()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractByteAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractShortAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractFloatAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before4.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before5$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigInteger");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before6.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.math.BigDecimal");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBigDecimalAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isGreaterThanOrEqualTo(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigInteger", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractComparableAssert isGreaterThan(..)", true), new UsesMethod("java.math.BigInteger valueOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBigDecimalAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBigDecimalAssert isGreaterThanOrEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }
}

