/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.migration.v8;

import ai.timefold.solver.migration.AbstractRecipe;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class SolverManagerBuilderRecipe
extends AbstractRecipe {
    private static final MatcherMeta[] MATCHER_METAS = new MatcherMeta[]{new MatcherMeta("solve(*..*,java.util.function.Function,java.util.function.Consumer,java.util.function.BiConsumer)", ".solveBuilder().withProblemId(#{any()}).withProblemFinder(#{any()}).withFinalBestSolutionConsumer(#{any(java.util.function.Consumer)}).withExceptionHandler(#{any(java.util.function.BiConsumer)}).run()"), new MatcherMeta("solve(*..*,*..*,java.util.function.Consumer,java.util.function.BiConsumer)", ".solveBuilder().withProblemId(#{any()}).withProblem(#{any()}).withFinalBestSolutionConsumer(#{any(java.util.function.Consumer)}).withExceptionHandler(#{any(java.util.function.BiConsumer)}).run()"), new MatcherMeta("solve(*..*,java.util.function.Function,java.util.function.Consumer)", ".solveBuilder().withProblemId(#{any()}).withProblemFinder(#{any()}).withFinalBestSolutionConsumer(#{any(java.util.function.Consumer)}).run()"), new MatcherMeta("solveAndListen(*..*,java.util.function.Function,java.util.function.Consumer)", ".solveBuilder().withProblemId(#{any()}).withProblemFinder(#{any()}).withBestSolutionConsumer(#{any(java.util.function.Consumer)}).run()"), new MatcherMeta("solveAndListen(*..*,java.util.function.Function,java.util.function.Consumer,java.util.function.BiConsumer)", ".solveBuilder().withProblemId(#{any()}).withProblemFinder(#{any()}).withBestSolutionConsumer(#{any(java.util.function.Consumer)}).withExceptionHandler(#{any(java.util.function.BiConsumer)}).run()"), new MatcherMeta("solveAndListen(*..*,java.util.function.Function,java.util.function.Consumer,java.util.function.Consumer,java.util.function.BiConsumer)", ".solveBuilder().withProblemId(#{any()}).withProblemFinder(#{any()}).withBestSolutionConsumer(#{any(java.util.function.Consumer)}).withFinalBestSolutionConsumer(#{any(java.util.function.Consumer)}).withExceptionHandler(#{any(java.util.function.BiConsumer)}).run()")};

    public String getDisplayName() {
        return "SolverManager: use builder API";
    }

    public String getDescription() {
        return "Use `solveBuilder()` instead of deprecated solve methods on `SolveManager`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor[] visitors = (TreeVisitor[])Arrays.stream(MATCHER_METAS).map(m -> new UsesMethod(m.methodMatcher)).toArray(TreeVisitor[]::new);
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])visitors), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public Expression visitExpression(Expression expression, ExecutionContext executionContext) {
                Expression e = super.visitExpression(expression, (Object)executionContext);
                MatcherMeta matcherMeta = Arrays.stream(MATCHER_METAS).filter(m -> m.methodMatcher.matches(e)).findFirst().orElse(null);
                if (matcherMeta == null) {
                    return e;
                }
                J.MethodInvocation mi = (J.MethodInvocation)e;
                Expression select = mi.getSelect();
                List arguments = mi.getArguments();
                String pattern = "#{any(" + matcherMeta.classFqn + ")}" + matcherMeta.pattern;
                return (Expression)JavaTemplate.builder((String)pattern).javaParser(AbstractRecipe.JAVA_PARSER).build().apply(this.getCursor(), e.getCoordinates().replace(), Stream.concat(Stream.of(select), arguments.stream()).toArray());
            }
        });
    }

    private static final class MatcherMeta {
        private final String classFqn;
        public final MethodMatcher methodMatcher;
        public final String methodName;
        private final String pattern;

        public MatcherMeta(String method, String pattern) {
            this.classFqn = "ai.timefold.solver.core.api.solver.SolverManager";
            this.methodMatcher = new MethodMatcher(this.classFqn + " " + method);
            this.methodName = method;
            this.pattern = pattern;
        }
    }
}

