/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssortedRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssortedRules` Refaster recipes";
    }

    public String getDescription() {
        return "Assorted Refaster rules that do not (yet) belong in one of the other classes with more topical Refaster rules [Source](https://error-prone.picnic.tech/refasterrules/AssortedRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CheckIndexRecipe(), new LogicalImplicationRecipe(), new SplitToStreamRecipe()});
    }

    @NullMarked
    public static class CheckIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.CheckIndex`";
        }

        public String getDescription() {
            return "Prefer `Objects#checkIndex(int, int)` over the Guava alternative";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkElementIndex(#{index:any(int)}, #{size:any(int)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Objects.checkIndex(#{index:any(int)}, #{size:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions.checkElementIndex");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Preconditions checkElementIndex(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogicalImplicationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.LogicalImplication`";
        }

        public String getDescription() {
            return "Don't unnecessarily repeat boolean expressions";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{firstTest:any(boolean)} || (!#{firstTest} && #{secondTest:any(boolean)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{firstTest:any(boolean)} || #{secondTest:any(boolean)}").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class SplitToStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.SplitToStream`";
        }

        public String getDescription() {
            return "Prefer `Splitter#splitToStream(CharSequence)` over less efficient alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{splitter:any(com.google.common.base.Splitter)}.split(#{charSequence:any(java.lang.CharSequence)}))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{splitter:any(com.google.common.base.Splitter)}.splitToList(#{charSequence:any(java.lang.CharSequence)}).stream()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{splitter:any(com.google.common.base.Splitter)}.splitToStream(#{charSequence:any(java.lang.CharSequence)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Splitter", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.base.Splitter splitToList(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Splitter split(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

