/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus30;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class AdjustKotlinAllOpenDirectives
extends Recipe {
    private static final String ALL_OPEN_ANNOTATION = "all-open:annotation=";
    private static final XPathMatcher PLUGIN_MATCHER = new XPathMatcher("/project/build/plugins/plugin");
    private static final List<String> JAVAX_PACKAGES = List.of("javax.ws.", "javax.enterprise.");

    public String getDisplayName() {
        return "Adjust all-open directives in Kotlin plugin configuration";
    }

    public String getDescription() {
        return "Adjust all-open directives in Kotlin plugin configuration";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (!PLUGIN_MATCHER.matches(this.getCursor())) {
                    return t;
                }
                if (!"org.jetbrains.kotlin".equals(t.getChildValue("groupId").orElse(null)) || !"kotlin-maven-plugin".equals(t.getChildValue("artifactId").orElse(null))) {
                    return t;
                }
                Optional configurationTag = t.getChild("configuration");
                if (configurationTag.isEmpty()) {
                    return t;
                }
                Optional pluginOptionsTag = ((Xml.Tag)configurationTag.get()).getChild("pluginOptions");
                if (pluginOptionsTag.isEmpty()) {
                    return t;
                }
                for (Xml.Tag pluginOptionTag : ((Xml.Tag)pluginOptionsTag.get()).getChildren()) {
                    t = this.adjustAllOpenDirectives(ctx, t, pluginOptionTag);
                }
                return t;
            }

            private Xml.Tag adjustAllOpenDirectives(ExecutionContext ctx, Xml.Tag pluginTag, Xml.Tag pluginOptionTag) {
                if (pluginOptionTag.getValue().isEmpty()) {
                    return pluginTag;
                }
                if (!((String)pluginOptionTag.getValue().get()).startsWith(AdjustKotlinAllOpenDirectives.ALL_OPEN_ANNOTATION)) {
                    return pluginTag;
                }
                for (String javaxPackage : JAVAX_PACKAGES) {
                    if (!((String)pluginOptionTag.getValue().get()).startsWith(AdjustKotlinAllOpenDirectives.ALL_OPEN_ANNOTATION + javaxPackage)) continue;
                    pluginTag = (Xml.Tag)new ChangeTagValueVisitor(pluginOptionTag, ((String)pluginOptionTag.getValue().get()).replace("all-open:annotation=javax.", "all-open:annotation=jakarta.")).visitNonNull((Tree)pluginTag, (Object)ctx);
                }
                return pluginTag;
            }
        };
    }

    @Generated
    public AdjustKotlinAllOpenDirectives() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AdjustKotlinAllOpenDirectives()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdjustKotlinAllOpenDirectives)) {
            return false;
        }
        AdjustKotlinAllOpenDirectives other = (AdjustKotlinAllOpenDirectives)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AdjustKotlinAllOpenDirectives;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

