/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel41;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelJavaVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class CamelCoreRecipe
extends Recipe {
    private static final String M_TO = "org.apache.camel.model.ProcessorDefinition to(..)";
    private static final String M_FROM = "org.apache.camel.model.ProcessorDefinition from(..)";
    private static final String AWS2_URL_WITH_QUEUE_REGEXP = "(aws2-sns://[a-zA-z]+?.*)queueUrl=https://(.+)";
    private static final Pattern AWS2_URL_WITH_QUEUE_URL = Pattern.compile("(aws2-sns://[a-zA-z]+?.*)queueUrl=https://(.+)");

    public String getDisplayName() {
        return "Camel Core changes";
    }

    public String getDescription() {
        return "Apache Camel Core migration from version 4.0 to 4.1.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelJavaVisitor(){

            @Override
            public J.Literal doVisitLiteral(J.Literal literal, ExecutionContext context) {
                J.Literal l = super.doVisitLiteral(literal, context);
                if (JavaType.Primitive.String.equals((Object)l.getType()) && AWS2_URL_WITH_QUEUE_URL.matcher((String)l.getValue()).matches()) {
                    String newUrl = ((String)l.getValue()).replaceFirst(CamelCoreRecipe.AWS2_URL_WITH_QUEUE_REGEXP, "$1queueArn=arn:aws:sqs:$2");
                    l = RecipesUtil.createStringLiteral(newUrl);
                }
                return l;
            }
        });
    }

    @Generated
    public CamelCoreRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CamelCoreRecipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelCoreRecipe)) {
            return false;
        }
        CamelCoreRecipe other = (CamelCoreRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelCoreRecipe;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

