/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class ByteBufferToSdkBytes
extends Recipe {
    private static final Pattern BYTE_BUFFER_PATTERN = Pattern.compile(ByteBuffer.class.getCanonicalName());

    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Convert ByteBuffer to SdkBytes";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Convert ByteBuffer to SdkBytes by calling SdkBytes#fromByteBuffer";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SdkBytesToBufferVisitor();
    }

    private static final class SdkBytesToBufferVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private SdkBytesToBufferVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation originalMethod, ExecutionContext executionContext) {
            J.MethodInvocation method = super.visitMethodInvocation(originalMethod, (Object)executionContext);
            if (!SdkBytesToBufferVisitor.isV2ModelSetterWithByteBufferParam(method)) {
                return method;
            }
            JavaTemplate template = JavaTemplate.builder((String)"SdkBytes.fromByteBuffer(#{any()})").contextSensitive().imports(new String[]{SdkBytes.class.getCanonicalName()}).build();
            method = (J.MethodInvocation)template.apply(this.updateCursor((Tree)method), method.getCoordinates().replaceArguments(), method.getArguments().toArray());
            this.maybeAddImport(SdkBytes.class.getCanonicalName(), false);
            return method;
        }

        private static boolean isV2ModelSetterWithByteBufferParam(J.MethodInvocation method) {
            JavaType.Method mt = method.getMethodType();
            if (mt != null) {
                JavaType.FullyQualified declaringType = mt.getDeclaringType();
                List parameterTypes = mt.getParameterTypes();
                if (parameterTypes.size() != 1) {
                    return false;
                }
                JavaType javaType = (JavaType)parameterTypes.get(0);
                if (javaType == null) {
                    return false;
                }
                boolean isByteBufferParam = javaType.isAssignableFrom(BYTE_BUFFER_PATTERN);
                if (SdkTypeUtils.isV2ModelBuilder((JavaType)declaringType) && isByteBufferParam) {
                    return true;
                }
            }
            return false;
        }
    }
}

