/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration.internal.utils;

import org.openrewrite.java.MethodMatcher;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class S3TransformUtils {
    public static final String V1_S3_CLIENT = "com.amazonaws.services.s3.AmazonS3";
    public static final String V1_S3_MODEL_PKG = "com.amazonaws.services.s3.model.";
    public static final String V2_S3_CLIENT = "software.amazon.awssdk.services.s3.S3Client";
    public static final String V2_S3_MODEL_PKG = "software.amazon.awssdk.services.s3.model.";
    public static final String V2_TM_CLIENT = "software.amazon.awssdk.transfer.s3.S3TransferManager";
    public static final String V2_TM_MODEL_PKG = "software.amazon.awssdk.transfer.s3.model.";

    private S3TransformUtils() {
    }

    public static MethodMatcher v1S3MethodMatcher(String methodSignature) {
        return new MethodMatcher("com.amazonaws.services.s3.AmazonS3 " + methodSignature, true);
    }

    public static MethodMatcher v2S3MethodMatcher(String methodSignature) {
        return new MethodMatcher("software.amazon.awssdk.services.s3.S3Client " + methodSignature, true);
    }

    public static MethodMatcher v2TmMethodMatcher(String methodSignature) {
        return new MethodMatcher("software.amazon.awssdk.transfer.s3.S3TransferManager " + methodSignature, true);
    }
}

