/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel41;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.camel.upgrade.AbstractCamelXmlVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class XmlDslRecipe
extends Recipe {
    private static final XPathMatcher XML_BEAN_MATCHER = new XPathMatcher("*/bean");

    public String getDisplayName() {
        return "Camel XMl DSL changes";
    }

    public String getDescription() {
        return "Apache Camel XML DSL migration from version 4.0 to 4.1.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelXmlVisitor(){

            @Override
            public Xml.Tag doVisitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.doVisitTag(tag, ctx);
                if (XML_BEAN_MATCHER.matches(this.getCursor()) && t.getChild("script").isPresent()) {
                    Optional<Xml.Attribute> typeAttr = t.getAttributes().stream().filter(a -> "type".equals(a.getKeyAsString())).findAny();
                    Optional<Xml.Attribute> beanTypeAttr = t.getAttributes().stream().filter(a -> "beanType".equals(a.getKeyAsString())).findAny();
                    if (typeAttr.isPresent() && !typeAttr.get().getValueAsString().isEmpty() && beanTypeAttr.isPresent() && !beanTypeAttr.get().getValueAsString().isEmpty()) {
                        ArrayList<Xml.Attribute> attrs = new ArrayList<Xml.Attribute>(t.getAttributes());
                        attrs.remove(typeAttr.get());
                        attrs.remove(beanTypeAttr.get());
                        Xml.Attribute.Value tmp = typeAttr.get().getValue();
                        attrs.add(typeAttr.get().withValue(beanTypeAttr.get().getValue()));
                        attrs.add(beanTypeAttr.get().withKey(new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, "scriptLanguage")).withValue(tmp));
                        t = t.withAttributes(attrs);
                    }
                }
                return t;
            }
        };
    }
}

