/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class CharSequenceRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`CharSequenceRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `CharSequence`s\n[Source](https://error-prone.picnic.tech/refasterrules/CharSequenceRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CharSequenceIsEmptyRecipe()});
    }

    @NullMarked
    public static class CharSequenceIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CharSequenceRules.CharSequenceIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `CharSequence#isEmpty()` over alternatives that consult the char sequence's length";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{charSequence:any(java.lang.CharSequence)}.length() == 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{charSequence:any(java.lang.CharSequence)}.length() <= 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{charSequence:any(java.lang.CharSequence)}.length() < 1").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{charSequence:any(java.lang.CharSequence)}.isEmpty()").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.CharSequence length(..)", true), (TreeVisitor)javaVisitor);
        }
    }
}

