/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class FileRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`FileRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with files\n[Source](https://error-prone.picnic.tech/refasterrules/FileRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new PathOfUriRecipe(), new PathInstanceRecipe(), new FilesReadStringWithCharsetRecipe(), new FilesReadStringRecipe(), new FilesCreateTempFileToFileRecipe(), new FilesCreateTempFileInCustomDirectoryToFileRecipe(), new PathToFileMkDirsFilesExistsRecipe(), new FileMkDirsFileExistsRecipe()});
    }

    @NullMarked
    public static class PathOfUriRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.PathOfUri`";
        }

        public String getDescription() {
            return "Prefer the more idiomatic `Path#of(URI)` over `Paths#get(URI)`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.nio.file.Paths.get(#{uri:any(java.net.URI)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Path.of(#{uri:any(java.net.URI)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.file.Paths");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URI", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("java.nio.file.Paths", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Paths get(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PathInstanceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.PathInstance`";
        }

        public String getDescription() {
            return "Avoid redundant conversions from `Path` to `File`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{path:any(java.nio.file.Path)}.toFile().toPath()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{path:any(java.nio.file.Path)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.io.File toPath(..)", true), new UsesMethod("java.nio.file.Path toFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesReadStringWithCharsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesReadStringWithCharset`";
        }

        public String getDescription() {
            return "Prefer `Files#readString(Path, Charset)` over more contrived alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new String(java.nio.file.Files.readAllBytes(#{path:any(java.nio.file.Path)}), #{charset:any(java.nio.charset.Charset)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)})").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.lang.String <constructor>(..)", true), new UsesMethod("java.nio.file.Files readAllBytes(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesReadStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesReadString`";
        }

        public String getDescription() {
            return "Prefer `Files#readString(Path)` over more verbose alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, java.nio.charset.StandardCharsets.UTF_8)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Files readString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesCreateTempFileToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        public String getDescription() {
            return "Note that `File#createTempFile` treats the given prefix as a path, and ignores all but\n its file name. That is, the actual prefix used is derived from all characters following the\n final file separator (if any). This is not the case with `Files#createTempFile`, which\n will instead throw an `IllegalArgumentException` if the prefix contains any file\n separators.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, null)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File createTempFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesCreateTempFileInCustomDirectoryToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(Path, String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        public String getDescription() {
            return "Note that `File#createTempFile` treats the given prefix as a path, and ignores all but\n its file name. That is, the actual prefix used is derived from all characters following the\n final file separator (if any). This is not the case with `Files#createTempFile`, which\n will instead throw an `IllegalArgumentException` if the prefix contains any file\n separators.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, #{directory:any(java.io.File)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.createTempFile(#{directory:any(java.io.File)}.toPath(), #{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(2), matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File createTempFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PathToFileMkDirsFilesExistsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.PathToFileMkDirsFilesExists`";
        }

        public String getDescription() {
            return "Invoke `File#mkdirs()` before `Files#exists(Path, LinkOption...)` to avoid concurrency issues";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.nio.file.Files.exists(#{path:any(java.nio.file.Path)}) || #{path}.toFile().mkdirs()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{path:any(java.nio.file.Path)}.toFile().mkdirs() || java.nio.file.Files.exists(#{path})").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.io.File mkdirs(..)", true), new UsesMethod("java.nio.file.Files exists(..)", true), new UsesMethod("java.nio.file.Path toFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FileMkDirsFileExistsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FileMkDirsFileExists`";
        }

        public String getDescription() {
            return "Invoke `File#mkdirs()` before `File#exists()` to avoid concurrency issues";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{file:any(java.io.File)}.exists() || #{file}.mkdirs()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{file:any(java.io.File)}.mkdirs() || #{file}.exists()").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File exists(..)", true), new UsesMethod("java.io.File mkdirs(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

