/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel30.yaml;

import io.quarkus.updates.camel30.yaml.YamlRecipesUtil;
import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.format.IndentsVisitor;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.tree.Yaml;

public final class CamelQuarkusYamlStepsInFromRecipe
extends Recipe {
    private static String[] PATHS_TO_PRE_CHECK = new String[]{"route.from"};
    private static JsonPathMatcher MATCHER_WITHOUT_ROUTE = new JsonPathMatcher("$.steps");
    private static JsonPathMatcher MATCHER_WITH_ROUTE = new JsonPathMatcher("$.route.steps");

    public String getDisplayName() {
        return "Camel Yaml steps not allowed as route child";
    }

    public String getDescription() {
        return "The YAML DSL backwards compatible mode in Camel 3.14 or older, which allowed 'steps' to be defined as a child of 'route' has been removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){
            Yaml.Mapping from = null;
            Yaml.Mapping.Entry steps = null;

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext context) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)context);
                if (this.steps == null && (MATCHER_WITH_ROUTE.matches(this.getCursor()) || MATCHER_WITHOUT_ROUTE.matches(this.getCursor()))) {
                    this.steps = e;
                    if (this.from != null) {
                        this.moveSteps();
                    }
                    return null;
                }
                return e;
            }

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext context) {
                Yaml.Mapping m = super.visitMapping(mapping, (Object)context);
                String prop = YamlRecipesUtil.getProperty(this.getCursor());
                if (("route.from".equals(prop) || "from".equals(prop)) && this.from == null) {
                    this.from = m;
                    if (this.steps != null) {
                        this.moveSteps();
                    }
                }
                return m;
            }

            private void moveSteps() {
                this.doAfterVisit((TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

                    public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext c) {
                        Yaml.Mapping m = super.visitMapping(mapping, (Object)c);
                        if (m == from) {
                            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>(m.getEntries());
                            entries.add(steps.copyPaste().withPrefix("\n"));
                            m = m.withEntries(entries);
                        }
                        return m;
                    }
                });
                this.doAfterVisit((TreeVisitor)new IndentsVisitor(new IndentsStyle(2), null));
            }
        };
    }

    @NonNull
    public String toString() {
        return "CamelQuarkusYamlStepsInFromRecipe()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelQuarkusYamlStepsInFromRecipe)) {
            return false;
        }
        CamelQuarkusYamlStepsInFromRecipe other = (CamelQuarkusYamlStepsInFromRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelQuarkusYamlStepsInFromRecipe;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

