/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus39;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RemoveMavenCompilerAnnotationProcessor
extends Recipe {
    @Option(displayName="Annotation processor groupId", description="The groupId of the annotation processor.", example="org.hibernate.orm", required=true)
    private final String groupId;
    @Option(displayName="Annotation processor artifactId", description="The artifactId of the annotation processor.", example="hibernate-jpamodelgen", required=true)
    private final String artifactId;
    @Option(displayName="Annotation processor fully-qualified class", description="The fully-qualified class of the annotation processor.", example="com.example.MyProcessor", required=false)
    private final String processorClass;

    public String getDisplayName() {
        return "Remove an annotation processor from the Maven Compiler plugin configuration";
    }

    public String getDescription() {
        return "Remove an annotation processor from the Maven Compiler plugin configuration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional configuration;
                Xml.Tag mavenCompilerPluginTag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin") && (configuration = mavenCompilerPluginTag.getChild("configuration")).isPresent()) {
                    Optional annotationProcessorsWrapper;
                    Optional annotationProcessorPathsWrapper = ((Xml.Tag)configuration.get()).getChild("annotationProcessorPaths");
                    if (annotationProcessorPathsWrapper.isPresent()) {
                        mavenCompilerPluginTag = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)((Xml.Tag)annotationProcessorPathsWrapper.get()), child -> !RemoveMavenCompilerAnnotationProcessor.this.groupId.equals(child.getChildValue("groupId").orElse(null)) || !RemoveMavenCompilerAnnotationProcessor.this.artifactId.equals(child.getChildValue("artifactId").orElse(null)));
                    }
                    if (RemoveMavenCompilerAnnotationProcessor.this.processorClass != null && (annotationProcessorsWrapper = ((Xml.Tag)configuration.get()).getChild("annotationProcessors")).isPresent()) {
                        mavenCompilerPluginTag = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)((Xml.Tag)annotationProcessorsWrapper.get()), child -> !RemoveMavenCompilerAnnotationProcessor.this.processorClass.equals(child.getValue().orElse(null)));
                    }
                }
                return mavenCompilerPluginTag;
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId", "processorClass"})
    public RemoveMavenCompilerAnnotationProcessor(String groupId, String artifactId, String processorClass) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.processorClass = processorClass;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getProcessorClass() {
        return this.processorClass;
    }

    @NonNull
    public String toString() {
        return "RemoveMavenCompilerAnnotationProcessor(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", processorClass=" + this.getProcessorClass() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveMavenCompilerAnnotationProcessor)) {
            return false;
        }
        RemoveMavenCompilerAnnotationProcessor other = (RemoveMavenCompilerAnnotationProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$processorClass = this.getProcessorClass();
        String other$processorClass = other.getProcessorClass();
        return !(this$processorClass == null ? other$processorClass != null : !this$processorClass.equals(other$processorClass));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveMavenCompilerAnnotationProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $processorClass = this.getProcessorClass();
        result = result * 59 + ($processorClass == null ? 43 : $processorClass.hashCode());
        return result;
    }
}

