/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class RxJava2AdapterRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `RxJava2Adapter`";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.RxJava2AdapterRules`. [Source](https://error-prone.picnic.tech/refasterrules/RxJava2AdapterRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CompletableToMonoRecipe()});
    }

    @NonNullApi
    public static class CompletableToMonoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Use the fluent API style when using `RxJava2Adapter#completableToMono`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CompletableToMono {\n    \n    @BeforeTemplate\n    Mono<@Nullable Void> before(Completable completable) {\n        return Refaster.anyOf(RxJava2Adapter.completableToMono(completable), completable.to(RxJava2Adapter::completableToMono));\n    }\n    \n    @AfterTemplate\n    Mono<@Nullable Void> after(Completable completable) {\n        return completable.as(RxJava2Adapter::completableToMono);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"reactor.adapter.rxjava.RxJava2Adapter.completableToMono(#{completable:any(io.reactivex.Completable)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"reactor-adapter", "rxjava"})).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.to(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"reactor-adapter", "rxjava"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{completable:any(io.reactivex.Completable)}.as(reactor.adapter.rxjava.RxJava2Adapter::completableToMono)").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"reactor-adapter", "rxjava"})).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.adapter.rxjava.RxJava2Adapter", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.Mono", Boolean.valueOf(true)), new UsesType("io.reactivex.Completable", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("reactor.adapter.rxjava.RxJava2Adapter completableToMono(..)"), new UsesMethod("io.reactivex.Completable to(..)")})}), (TreeVisitor)javaVisitor);
        }
    }
}

