/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJIterableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJIterableRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJIterableRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJIterableRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatIterableIsEmptyRecipe(), new AssertThatIterableIsNotEmptyRecipe(), new AssertThatIterableSizeRecipe(), new AssertThatIterableHasOneElementEqualToRecipe()});
    }

    @NullMarked
    public static class AssertThatIterableIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJIterableRules.AssertThatIterableIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableIsEmpty<E> {\n    \n    @BeforeTemplate\n    void before(Iterable<E> iterable) {\n        assertThat(iterable.iterator()).isExhausted();\n    }\n    \n    @BeforeTemplate\n    void before(Collection<E> iterable) {\n        assertThat(iterable.isEmpty()).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Collection<E> iterable) {\n        assertThat(iterable).isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}.iterator()).isExhausted();").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}.isEmpty()).isTrue();").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}).isEmpty();").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Iterable iterator(..)", true), new UsesMethod("org.assertj.core.api.AbstractIteratorAssert isExhausted(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection isEmpty(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIterableIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJIterableRules.AssertThatIterableIsNotEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableIsNotEmpty<E> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Iterable<E> iterable) {\n        return assertThat(iterable.iterator()).hasNext();\n    }\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Collection<E> iterable) {\n        return assertThat(iterable.isEmpty()).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    IterableAssert<E> after(Iterable<E> iterable) {\n        return assertThat(iterable).isNotEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}.iterator()).hasNext()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}.isEmpty()).isFalse()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).isNotEmpty()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        this.maybeRemoveImport("java.util.Collection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Iterable iterator(..)", true), new UsesMethod("org.assertj.core.api.AbstractIteratorAssert hasNext(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection isEmpty(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIterableSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJIterableRules.AssertThatIterableSize`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableSize<E> {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(Iterable<E> iterable) {\n        return assertThat(Iterables.size(iterable));\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(Collection<E> iterable) {\n        return assertThat(iterable.size());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractIntegerAssert<?> after(Iterable<E> iterable) {\n        return assertThat(iterable).size();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(com.google.common.collect.Iterables.size(#{iterable:any(java.lang.Iterable<E>)}))").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.util.Collection<E>)}.size())").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<E>)}).size()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables size(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection size(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIterableHasOneElementEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJIterableRules.AssertThatIterableHasOneElementEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIterableHasOneElementEqualTo<S, E extends S> {\n    \n    @BeforeTemplate\n    ObjectAssert<S> before(Iterable<S> iterable, E element) {\n        return assertThat(Iterables.getOnlyElement(iterable)).isEqualTo(element);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    IterableAssert<S> after(Iterable<S> iterable, E element) {\n        return assertThat(iterable).containsExactly(element);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(com.google.common.collect.Iterables.getOnlyElement(#{iterable:any(java.lang.Iterable<S>)})).isEqualTo(#{element:any(E)})").genericTypes(new String[]{"S", "E extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{iterable:any(java.lang.Iterable<S>)}).containsExactly(#{element:any(E)})").genericTypes(new String[]{"S", "E extends S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        this.maybeRemoveImport("org.assertj.core.api.ObjectAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ObjectAssert", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables getOnlyElement(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

