/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel46;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelYamlVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class YamlDsl46Recipe
extends Recipe {
    public String getDisplayName() {
        return "Bean property to properties.";
    }

    public String getDescription() {
        return "Each bean property is changed to bean properties.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelYamlVisitor(){

            @Override
            protected void clearLocalCache() {
            }

            @Override
            public Yaml.Mapping.Entry doVisitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                String key;
                Yaml.Mapping.Entry e = super.doVisitMappingEntry(entry, ctx);
                String path = RecipesUtil.getProperty(this.getCursor());
                if (path.endsWith("beans.property")) {
                    Yaml.Mapping m = (Yaml.Mapping)((Yaml.Sequence.Entry)((Yaml.Sequence)e.getValue()).getEntries().get(0)).getBlock();
                    String prefix = e.getPrefix() + "  ";
                    List entries = ((Yaml.Sequence)e.getValue()).getEntries().stream().flatMap(entry1 -> ((Yaml.Mapping)entry1.getBlock()).getEntries().stream()).map(entry2 -> entry2.withPrefix(prefix)).collect(Collectors.toList());
                    return e.withKey((YamlKey)((Yaml.Scalar)e.getKey().copyPaste()).withValue("properties")).withValue((Yaml.Block)m.copyPaste().withEntries(entries));
                }
                if (path.matches(".*beans.property.key") && e.getValue() instanceof Yaml.Scalar) {
                    this.getCursor().getParent(4).putMessage("key", (Object)((Yaml.Scalar)e.getValue()).getValue());
                    return null;
                }
                if (path.matches(".*beans.property.value") && e.getValue() instanceof Yaml.Scalar && this.getCursor().getNearestMessage("key") != null && (key = (String)this.getCursor().getNearestMessage("key")) != null) {
                    return e.withKey((YamlKey)((Yaml.Scalar)e.getKey().copyPaste()).withValue(key));
                }
                return e;
            }
        };
    }

    @Generated
    public YamlDsl46Recipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "YamlDsl46Recipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlDsl46Recipe)) {
            return false;
        }
        YamlDsl46Recipe other = (YamlDsl46Recipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof YamlDsl46Recipe;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

