/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class S3UriToV2
extends Recipe {
    private static final Pattern V1_AMAZON_S3_URI = Pattern.compile("com.amazonaws.services.s3.AmazonS3URI");
    private static final String V2_S3_URI = "software.amazon.awssdk.services.s3.S3Uri";

    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Convert v1 AmazonS3URI to v2 S3Uri";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Convert v1 AmazonS3URI to v2 S3Uri";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDecls, ExecutionContext ctx) {
            J.VariableDeclarations varDec = (J.VariableDeclarations)super.visitVariableDeclarations(variableDecls, (Object)ctx);
            JavaType type = varDec.getType();
            if (type == null) {
                return varDec;
            }
            if (!type.isAssignableFrom(V1_AMAZON_S3_URI)) {
                return varDec;
            }
            this.addV2S3UriImport();
            this.removeV1S3UriImport();
            JavaType v2Type = JavaType.buildType((String)S3UriToV2.V2_S3_URI);
            TypeTree v2TypeTree = TypeTree.build((String)"S3Uri");
            return varDec.withType(v2Type).withTypeExpression(v2TypeTree);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String v2Method;
            String methodName;
            JavaType.Method methodType = (method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx)).getMethodType();
            if (methodType == null) {
                return method;
            }
            Expression select = method.getSelect();
            if (select == null) {
                return method;
            }
            JavaType selectType = select.getType();
            if (selectType == null || !selectType.isAssignableFrom(V1_AMAZON_S3_URI)) {
                return method;
            }
            switch (methodName = method.getSimpleName()) {
                case "getVersionId": {
                    v2Method = "#{any()}.firstMatchingRawQueryParameter(\"versionId\").orElse(null)";
                    break;
                }
                case "getBucket": {
                    v2Method = "#{any()}.bucket().orElse(null)";
                    break;
                }
                case "getKey": {
                    v2Method = "#{any()}.key().orElse(null)";
                    break;
                }
                case "getRegion": {
                    v2Method = "#{any()}.region().map(Region::id).orElse(null)";
                    this.addV2RegionImport();
                    break;
                }
                default: {
                    return method;
                }
            }
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
        }

        public J visitNewClass(J.NewClass previousNewClass, ExecutionContext ctx) {
            J.NewClass newClass = (J.NewClass)super.visitNewClass(previousNewClass, (Object)ctx).cast();
            JavaType type = newClass.getType();
            if (!(type instanceof JavaType.FullyQualified) || !type.isAssignableFrom(V1_AMAZON_S3_URI)) {
                return newClass;
            }
            List args = newClass.getArguments();
            Expression uriArg = (Expression)args.get(0);
            JavaType uriType = uriArg.getType();
            if (uriType == null) {
                return newClass;
            }
            StringBuilder sb = new StringBuilder("S3Utilities.builder().build().parseUri(");
            if (SdkTypeUtils.isUriType(uriType)) {
                sb.append("#{any()})");
            } else if (SdkTypeUtils.isStringType(uriType)) {
                sb.append("URI.create(#{any()})");
                this.addJavaUriImport();
            }
            J.MethodInvocation newMethod = (J.MethodInvocation)JavaTemplate.builder((String)sb.toString()).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{uriArg});
            if (this.shouldAddWarning(uriType, args)) {
                newMethod = (J.MethodInvocation)newMethod.withComments(this.v2DoesNotEncodeWarning());
            }
            this.removeV1S3UriImport();
            this.addS3UtilitiesImport();
            return newMethod;
        }

        private boolean shouldAddWarning(JavaType uriType, List<Expression> args) {
            if (SdkTypeUtils.isUriType(uriType)) {
                return false;
            }
            if (args.size() == 1) {
                return true;
            }
            return !this.urlEncodeArgIsLiteralFalse(args.get(1));
        }

        private boolean urlEncodeArgIsLiteralFalse(Expression arg) {
            if (arg instanceof J.Literal) {
                J.Literal literal = (J.Literal)arg;
                return literal.getValue().equals(Boolean.FALSE);
            }
            return false;
        }

        private List<Comment> v2DoesNotEncodeWarning() {
            String warning = "v2 S3Uri does not URL-encode a String URI. If you relied on this functionality in v1 you must update your code to manually encode the String.";
            return S3TransformUtils.createComments(warning);
        }

        private void removeV1S3UriImport() {
            this.doAfterVisit((TreeVisitor)new RemoveImport(V1_AMAZON_S3_URI.toString(), true));
        }

        private void addV2S3UriImport() {
            this.doAfterVisit((TreeVisitor)new AddImport(S3UriToV2.V2_S3_URI, null, false));
        }

        private void addS3UtilitiesImport() {
            String fqcn = "software.amazon.awssdk.services.s3.S3Utilities";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addV2RegionImport() {
            String fqcn = "software.amazon.awssdk.regions.Region";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addJavaUriImport() {
            String fqcn = "java.net.URI";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }
    }
}

