/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJStringRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJStringRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJStringRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJStringRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractStringAssertStringIsEmptyRecipe(), new AbstractStringAssertStringIsNotEmptyRecipe(), new AssertThatStringContainsRecipe(), new AssertThatStringDoesNotContainRecipe(), new AssertThatMatchesRecipe(), new AssertThatDoesNotMatchRecipe(), new AssertThatPathContentRecipe(), new AssertThatPathContentUtf8Recipe()});
    }

    @NullMarked
    public static class AbstractStringAssertStringIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AbstractStringAssertStringIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractStringAssertStringIsEmpty {\n    \n    @BeforeTemplate\n    void before(AbstractStringAssert<?> stringAssert) {\n        stringAssert.isEqualTo(\"\");\n    }\n    \n    @AfterTemplate\n    void after(AbstractStringAssert<?> stringAssert) {\n        stringAssert.isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isEqualTo(\"\");").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isEmpty();").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractStringAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractStringAssertStringIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AbstractStringAssertStringIsNotEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractStringAssertStringIsNotEmpty {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(AbstractStringAssert<?> stringAssert) {\n        return stringAssert.isNotEqualTo(\"\");\n    }\n    \n    @AfterTemplate\n    AbstractStringAssert<?> after(AbstractStringAssert<?> stringAssert) {\n        return stringAssert.isNotEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isNotEqualTo(\"\")").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stringAssert:any(org.assertj.core.api.AbstractStringAssert<?>)}.isNotEmpty()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractAssert isNotEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStringContainsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatStringContains`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringContains {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, CharSequence substring) {\n        return assertThat(string.contains(substring)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, CharSequence substring) {\n        return assertThat(string).contains(substring);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.contains(#{substring:any(java.lang.CharSequence)})).isTrue()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).contains(#{substring:any(java.lang.CharSequence)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.String contains(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStringDoesNotContainRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatStringDoesNotContain`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStringDoesNotContain {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(String string, CharSequence substring) {\n        return assertThat(string.contains(substring)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(String string, CharSequence substring) {\n        return assertThat(string).doesNotContain(substring);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.contains(#{substring:any(java.lang.CharSequence)})).isFalse()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).doesNotContain(#{substring:any(java.lang.CharSequence)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.String contains(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatMatchesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatMatches`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMatches {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string, String regex) {\n        return assertThat(string.matches(regex)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string, String regex) {\n        return assertThat(string).matches(regex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.matches(#{regex:any(java.lang.String)})).isTrue()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).matches(#{regex:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.String matches(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatDoesNotMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatDoesNotMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatDoesNotMatch {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(String string, String regex) {\n        return assertThat(string.matches(regex)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractAssert<?, ?> after(String string, String regex) {\n        return assertThat(string).doesNotMatch(regex);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}.matches(#{regex:any(java.lang.String)})).isFalse()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{string:any(java.lang.String)}).doesNotMatch(#{regex:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("java.lang.String matches(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatPathContentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatPathContent`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPathContent {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(Path path, Charset charset) throws IOException {\n        return assertThat(Files.readString(path, charset));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(Path path, Charset charset) {\n        return assertThat(path).content(charset);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)}))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{path:any(java.nio.file.Path)}).content(#{charset:any(java.nio.charset.Charset)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.file.Files");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Files readString(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatPathContentUtf8Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJStringRules.AssertThatPathContentUtf8`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPathContentUtf8 {\n    \n    @BeforeTemplate\n    AbstractStringAssert<?> before(Path path) throws IOException {\n        return assertThat(Files.readString(path));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractStringAssert<?> after(Path path) {\n        return assertThat(path).content(UTF_8);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{path:any(java.nio.file.Path)}).content(java.nio.charset.StandardCharsets.UTF_8)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.file.Files");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractStringAssert", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Files readString(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

