/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssortedRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssortedRules` Refaster recipes";
    }

    public String getDescription() {
        return "Assorted Refaster rules that do not (yet) belong in one of the other classes with more topical Refaster rules.\n[Source](https://error-prone.picnic.tech/refasterrules/AssortedRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CheckIndexRecipe(), new IteratorGetNextOrDefaultRecipe(), new LogicalImplicationRecipe(), new UnboundedSingleElementStreamRecipe(), new DisjointSetsRecipe(), new DisjointCollectionsRecipe(), new IterableIsEmptyRecipe(), new SplitToStreamRecipe()});
    }

    @NullMarked
    public static class CheckIndexRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.CheckIndex`";
        }

        public String getDescription() {
            return "Prefer `Objects#checkIndex(int, int)` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.base.Preconditions.checkElementIndex(#{index:any(int)}, #{size:any(int)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Objects.checkIndex(#{index:any(int)}, #{size:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.base.Preconditions.checkElementIndex");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.base.Preconditions checkElementIndex(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IteratorGetNextOrDefaultRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.IteratorGetNextOrDefault`";
        }

        public String getDescription() {
            return "Prefer `Iterators#getNext(Iterator, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{iterator:any(java.util.Iterator<T>)}.hasNext() ? #{iterator}.next() : #{defaultValue:any(T)}").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterator:any(java.util.Iterator<T>)}).findFirst().orElse(#{defaultValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterator:any(java.util.Iterator<T>)}).findAny().orElse(#{defaultValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.Iterators.getNext(#{iterator:any(java.util.Iterator<T>)}, #{defaultValue:any(T)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Iterator hasNext(..)", true), new UsesMethod("java.util.Iterator next(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.Optional orElse(..)", true), new UsesMethod("java.util.stream.Stream findAny(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.Optional orElse(..)", true), new UsesMethod("java.util.stream.Stream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LogicalImplicationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.LogicalImplication`";
        }

        public String getDescription() {
            return "Don't unnecessarily repeat boolean expressions.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S2589");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{firstTest:any(boolean)} || (!#{firstTest} && #{secondTest:any(boolean)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{firstTest:any(boolean)} || #{secondTest:any(boolean)}").build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class UnboundedSingleElementStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.UnboundedSingleElementStream`";
        }

        public String getDescription() {
            return "Prefer `Stream#generate(java.util.function.Supplier)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(com.google.common.collect.Iterables.cycle(#{object:any(T)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.Stream.generate(()->#{object:any(T)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables cycle(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DisjointSetsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.DisjointSets`";
        }

        public String getDescription() {
            return "Prefer `Collections#disjoint(Collection, Collection)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Sets.intersection(#{collection1:any(java.util.Set<T>)}, #{collection2:any(java.util.Set<T>)}).isEmpty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{collection1:any(java.util.Collection<T>)}.stream().noneMatch(#{collection2:any(java.util.Collection<T>)}::contains)").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Sets");
                        this.maybeRemoveImport("java.util.Set");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Sets", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Sets intersection(..)", true), new UsesMethod("java.util.AbstractCollection isEmpty(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream noneMatch(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DisjointCollectionsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.DisjointCollections`";
        }

        public String getDescription() {
            return "Don't unnecessarily copy collections before passing them to `Collections#disjoint(Collection, Collection)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"java.util.Collections.disjoint(com.google.common.collect.ImmutableSet.copyOf(#{collection1:any(java.util.Collection<T>)}), #{collection2:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.Collections.disjoint(new java.util.HashSet<>(#{collection1:any(java.util.Collection<T>)}), #{collection2:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, com.google.common.collect.ImmutableSet.copyOf(#{collection2:any(java.util.Collection<T>)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, new java.util.HashSet<>(#{collection2:any(java.util.Collection<T>)}))").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Collections.disjoint(#{collection1:any(java.util.Collection<T>)}, #{collection2:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.HashSet");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSet");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.HashSet");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collections disjoint(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSet copyOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.HashSet", Boolean.valueOf(true)), new UsesMethod("java.util.HashSet <constructor>(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IterableIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.IterableIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `Iterables#isEmpty(Iterable)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"!#{iterable:any(java.lang.Iterable<T>)}.iterator().hasNext()").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.Iterables.isEmpty(#{iterable:any(java.lang.Iterable<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Iterable iterator(..)", true), new UsesMethod("java.util.Iterator hasNext(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SplitToStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssortedRules.SplitToStream`";
        }

        public String getDescription() {
            return "Prefer `Splitter#splitToStream(CharSequence)` over less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{splitter:any(com.google.common.base.Splitter)}.split(#{charSequence:any(java.lang.CharSequence)}))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{splitter:any(com.google.common.base.Splitter)}.splitToList(#{charSequence:any(java.lang.CharSequence)}).stream()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{splitter:any(com.google.common.base.Splitter)}.splitToStream(#{charSequence:any(java.lang.CharSequence)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.Splitter", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.base.Splitter splitToList(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.Splitter split(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

