/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ClassRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ClassRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with classes.\n[Source](https://error-prone.picnic.tech/refasterrules/ClassRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ClassIsInstanceRecipe()});
    }

    @NullMarked
    public static class ClassIsInstanceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ClassRules.ClassIsInstance`";
        }

        public String getDescription() {
            return "Prefer `Class#isInstance(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{clazz:any(java.lang.Class<T>)}.isAssignableFrom(#{object:any(S)}.getClass())").genericTypes(new String[]{"T", "S"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{clazz:any(java.lang.Class<T>)}.isInstance(#{object:any(S)})").genericTypes(new String[]{"T", "S"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Class isAssignableFrom(..)", true), new UsesMethod("java.lang.Object getClass(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

