/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJEnumerableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJEnumerableRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJEnumerableRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJEnumerableRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new EnumerableAssertIsEmptyRecipe(), new EnumerableAssertIsNotEmptyRecipe(), new EnumerableAssertHasSizeRecipe(), new EnumerableAssertHasSizeLessThanRecipe(), new EnumerableAssertHasSizeLessThanOrEqualToRecipe(), new EnumerableAssertHasSizeGreaterThanRecipe(), new EnumerableAssertHasSizeGreaterThanOrEqualToRecipe(), new EnumerableAssertHasSizeBetweenRecipe(), new EnumerableAssertHasSameSizeAsRecipe()});
    }

    @NullMarked
    public static class EnumerableAssertIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertIsEmpty<E> {\n    \n    @BeforeTemplate\n    void before(EnumerableAssert<?, E> enumAssert) {\n        Refaster.anyOf(enumAssert.hasSize(0), enumAssert.hasSizeLessThanOrEqualTo(0), enumAssert.hasSizeLessThan(1));\n    }\n    \n    @BeforeTemplate\n    void before(AbstractIterableAssert<?, ?, E, ?> enumAssert) {\n        enumAssert.size().isNotPositive();\n    }\n    \n    @AfterTemplate\n    void after(EnumerableAssert<?, E> enumAssert) {\n        enumAssert.isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSize(0);").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThanOrEqualTo(0);").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThan(1);").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isNotPositive();").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isEmpty();").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNotPositive(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.EnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.EnumerableAssert hasSize(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.EnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.EnumerableAssert hasSizeLessThan(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.EnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.EnumerableAssert hasSizeLessThanOrEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertIsNotEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertIsNotEmpty<E> {\n    \n    @BeforeTemplate\n    EnumerableAssert<?, E> before(EnumerableAssert<?, E> enumAssert) {\n        return Refaster.anyOf(enumAssert.hasSizeGreaterThan(0), enumAssert.hasSizeGreaterThanOrEqualTo(1));\n    }\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert) {\n        return Refaster.anyOf(enumAssert.size().isNotEqualTo(0).returnToIterable(), enumAssert.size().isPositive().returnToIterable());\n    }\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert) {\n        return Refaster.anyOf(enumAssert.size().isNotEqualTo(0), enumAssert.size().isPositive());\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert) {\n        return enumAssert.isNotEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThan(0)").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThanOrEqualTo(1)").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isNotEqualTo(0).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isPositive().returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$0 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isNotEqualTo(0)").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2$1 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isPositive()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.isNotEmpty()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNotEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isPositive(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isNotEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isPositive(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.EnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.EnumerableAssert hasSizeGreaterThan(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.EnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.EnumerableAssert hasSizeGreaterThanOrEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSize`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSize<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isEqualTo(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isEqualTo(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSize(size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isEqualTo(#{size:any(int)}).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isEqualTo(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSize(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableSizeAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSizeLessThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeLessThan`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeLessThan<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThan(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThan(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeLessThan(size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThan(#{size:any(int)}).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThan(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThan(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isLessThan(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableSizeAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSizeLessThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeLessThanOrEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeLessThanOrEqualTo<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThanOrEqualTo(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isLessThanOrEqualTo(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeLessThanOrEqualTo(size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThanOrEqualTo(#{size:any(int)}).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isLessThanOrEqualTo(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeLessThanOrEqualTo(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isLessThanOrEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableSizeAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSizeGreaterThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeGreaterThan`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeGreaterThan<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThan(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThan(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeGreaterThan(size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThan(#{size:any(int)}).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThan(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThan(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isGreaterThan(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableSizeAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSizeGreaterThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeGreaterThanOrEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeGreaterThanOrEqualTo<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThanOrEqualTo(size).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int size) {\n        return enumAssert.size().isGreaterThanOrEqualTo(size);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int size) {\n        return enumAssert.hasSizeGreaterThanOrEqualTo(size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThanOrEqualTo(#{size:any(int)}).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isGreaterThanOrEqualTo(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeGreaterThanOrEqualTo(#{size:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isGreaterThanOrEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableSizeAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSizeBetweenRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSizeBetween`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSizeBetween<E> {\n    \n    @BeforeTemplate\n    AbstractIterableAssert<?, ?, E, ?> before(AbstractIterableAssert<?, ?, E, ?> enumAssert, int lower, int upper) {\n        return enumAssert.size().isBetween(lower, upper).returnToIterable();\n    }\n    \n    @BeforeTemplate\n    AbstractIterableSizeAssert<?, ?, E, ?> before2(AbstractIterableAssert<?, ?, E, ?> enumAssert, int lower, int upper) {\n        return enumAssert.size().isBetween(lower, upper);\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert, int lower, int upper) {\n        return enumAssert.hasSizeBetween(lower, upper);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isBetween(#{lower:any(int)}, #{upper:any(int)}).returnToIterable()").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.AbstractIterableAssert<?, ?, E, ?>)}.size().isBetween(#{lower:any(int)}, #{upper:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, E>)}.hasSizeBetween(#{lower:any(int)}, #{upper:any(int)})").genericTypes(new String[]{"E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableSizeAssert");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIterableAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isBetween(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert size(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractIterableSizeAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableSizeAssert returnToIterable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EnumerableAssertHasSameSizeAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJEnumerableRules.EnumerableAssertHasSameSizeAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class EnumerableAssertHasSameSizeAs<S, E> {\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Iterable<E> iterable) {\n        return enumAssert.hasSize(Iterables.size(iterable));\n    }\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Collection<E> iterable) {\n        return enumAssert.hasSize(iterable.size());\n    }\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, E[] iterable) {\n        return enumAssert.hasSize(iterable.length);\n    }\n    \n    @BeforeTemplate\n    EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, CharSequence iterable) {\n        return enumAssert.hasSize(iterable.length());\n    }\n    \n    @AfterTemplate\n    EnumerableAssert<?, S> after(EnumerableAssert<?, S> enumAssert, Iterable<E> iterable) {\n        return enumAssert.hasSameSizeAs(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(com.google.common.collect.Iterables.size(#{iterable:any(java.lang.Iterable<E>)}))").genericTypes(new String[]{"S", "E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(#{iterable:any(java.util.Collection<E>)}.size())").genericTypes(new String[]{"S", "E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(#{iterable:any(E[])}.length)").genericTypes(new String[]{"S", "E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSize(#{iterable:any(java.lang.CharSequence)}.length())").genericTypes(new String[]{"S", "E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{enumAssert:any(org.assertj.core.api.EnumerableAssert<?, S>)}.hasSameSizeAs(#{iterable:any(java.lang.Iterable<E>)})").genericTypes(new String[]{"S", "E"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.EnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.EnumerableAssert hasSize(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

