/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class CollectionRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`CollectionRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with (arbitrary) collections.\n[Source](https://error-prone.picnic.tech/refasterrules/CollectionRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new CollectionIsEmptyRecipe(), new CollectionSizeRecipe(), new CollectionContainsRecipe(), new CollectionAddAllToCollectionExpressionRecipe(), new CollectionAddAllToCollectionBlockRecipe(), new CollectionRemoveAllFromCollectionExpressionRecipe(), new CollectionRemoveAllFromCollectionBlockRecipe(), new SetStreamRecipe(), new NewArrayListFromCollectionRecipe(), new ImmutableCollectionAsListRecipe(), new ImmutableCollectionStreamRecipe(), new ImmutableCollectionContainsRecipe(), new ImmutableCollectionParallelStreamRecipe(), new ImmutableCollectionToStringRecipe(), new CollectionToArrayRecipe(), new ImmutableCollectionToArrayWithArrayRecipe(), new ImmutableCollectionToArrayWithGeneratorRecipe(), new CollectionIteratorRecipe(), new OptionalFirstCollectionElementRecipe(), new RemoveOptionalFirstNavigableSetElementRecipe(), new CollectionForEachRecipe()});
    }

    @NullMarked
    public static class CollectionIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionIsEmpty`";
        }

        public String getDescription() {
            return "Prefer `Collection#isEmpty()` over alternatives that consult the collection's size or are otherwise more contrived.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S1155");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.size() == 0").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.size() <= 0").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.size() < 1").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"com.google.common.collect.Iterables.isEmpty(#{collection:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$4 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().findAny().isEmpty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$5 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().findFirst().isEmpty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().isEmpty()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.isEmpty()").genericTypes(new String[]{"T"}).build();

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$4.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$5.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$4.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$5.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("java.util.AbstractCollection isEmpty(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables isEmpty(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection size(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Optional isEmpty(..)", true), new UsesMethod("java.util.stream.Stream findAny(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Optional isEmpty(..)", true), new UsesMethod("java.util.stream.Stream findFirst(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionSize`";
        }

        public String getDescription() {
            return "Prefer `Collection#size()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Iterables.size(#{collection:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().size()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.size()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("java.util.List size(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables size(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionContainsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionContains`";
        }

        public String getDescription() {
            return "Prefer `Collection#contains(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().anyMatch(#{value:any(S)}::equals)").genericTypes(new String[]{"T", "S"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.contains(#{value:any(S)})").genericTypes(new String[]{"T", "S"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream anyMatch(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionAddAllToCollectionExpressionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionAddAllToCollectionExpression`";
        }

        public String getDescription() {
            return "Don't call `Iterables#addAll(Collection, Iterable)` when the elements to be added are already part of a `Collection`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Iterables.addAll(#{addTo:any(java.util.Collection<T>)}, #{elementsToAdd:any(java.util.Collection<S>)})").genericTypes(new String[]{"T", "S extends T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{addTo:any(java.util.Collection<T>)}.addAll(#{elementsToAdd:any(java.util.Collection<S>)})").genericTypes(new String[]{"T", "S extends T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables addAll(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionAddAllToCollectionBlockRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionAddAllToCollectionBlock`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CollectionAddAllToCollectionBlock<T, S extends T> {\n    \n    @BeforeTemplate\n    void before(Collection<T> addTo, Collection<S> elementsToAdd) {\n        elementsToAdd.forEach(addTo::add);\n    }\n    \n    @BeforeTemplate\n    void before2(Collection<T> addTo, Collection<S> elementsToAdd) {\n        for (T element : elementsToAdd) {\n            addTo.add(element);\n        }\n    }\n    \n    @BeforeTemplate\n    void before3(Collection<T> addTo, Collection<S> elementsToAdd) {\n        for (S element : elementsToAdd) {\n            addTo.add(element);\n        }\n    }\n    \n    @AfterTemplate\n    void after(Collection<T> addTo, Collection<S> elementsToAdd) {\n        addTo.addAll(elementsToAdd);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{elementsToAdd:any(java.util.Collection<S>)}.forEach(#{addTo:any(java.util.Collection<T>)}::add);").genericTypes(new String[]{"T", "S extends T"}).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"for (T element : #{elementsToAdd:any(java.util.Collection<S>)}) {\n    #{addTo:any(java.util.Collection<T>)}.add(element);\n}").genericTypes(new String[]{"T", "S extends T"}).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"for (S element : #{elementsToAdd:any(java.util.Collection<S>)}) {\n    #{addTo:any(java.util.Collection<T>)}.add(element);\n}").genericTypes(new String[]{"T", "S extends T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{addTo:any(java.util.Collection<T>)}.addAll(#{elementsToAdd:any(java.util.Collection<S>)});").genericTypes(new String[]{"T", "S extends T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitStatement(Statement elem, ExecutionContext ctx) {
                    if (elem instanceof J.Block) {
                        return elem;
                    }
                    JavaTemplate.Matcher matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitStatement(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Iterable forEach(..)", true), new UsesMethod("java.util.Collection add(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionRemoveAllFromCollectionExpressionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionRemoveAllFromCollectionExpression`";
        }

        public String getDescription() {
            return "Don't call `Iterables#removeAll(Iterable, Collection)` when the elements to be removed are already part of a `Collection`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Iterables.removeAll(#{removeTo:any(java.util.Collection<T>)}, #{elementsToRemove:any(java.util.Collection<S>)})").genericTypes(new String[]{"T", "S extends T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{removeTo:any(java.util.Collection<T>)}.removeAll(#{elementsToRemove:any(java.util.Collection<S>)})").genericTypes(new String[]{"T", "S extends T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Iterables");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Iterables", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Iterables removeAll(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionRemoveAllFromCollectionBlockRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionRemoveAllFromCollectionBlock`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CollectionRemoveAllFromCollectionBlock<T, S extends T> {\n    \n    @BeforeTemplate\n    void before(Collection<T> removeFrom, Collection<S> elementsToRemove) {\n        elementsToRemove.forEach(removeFrom::remove);\n    }\n    \n    @BeforeTemplate\n    void before2(Collection<T> removeFrom, Collection<S> elementsToRemove) {\n        for (T element : elementsToRemove) {\n            removeFrom.remove(element);\n        }\n    }\n    \n    @BeforeTemplate\n    void before3(Collection<T> removeFrom, Collection<S> elementsToRemove) {\n        for (S element : elementsToRemove) {\n            removeFrom.remove(element);\n        }\n    }\n    \n    @AfterTemplate\n    void after(Collection<T> removeFrom, Collection<S> elementsToRemove) {\n        removeFrom.removeAll(elementsToRemove);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{elementsToRemove:any(java.util.Collection<S>)}.forEach(#{removeFrom:any(java.util.Collection<T>)}::remove);").genericTypes(new String[]{"T", "S extends T"}).build();
                final JavaTemplate before2 = JavaTemplate.builder((String)"for (T element : #{elementsToRemove:any(java.util.Collection<S>)}) {\n    #{removeFrom:any(java.util.Collection<T>)}.remove(element);\n}").genericTypes(new String[]{"T", "S extends T"}).build();
                final JavaTemplate before3 = JavaTemplate.builder((String)"for (S element : #{elementsToRemove:any(java.util.Collection<S>)}) {\n    #{removeFrom:any(java.util.Collection<T>)}.remove(element);\n}").genericTypes(new String[]{"T", "S extends T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{removeFrom:any(java.util.Collection<T>)}.removeAll(#{elementsToRemove:any(java.util.Collection<S>)});").genericTypes(new String[]{"T", "S extends T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitStatement(Statement elem, ExecutionContext ctx) {
                    if (elem instanceof J.Block) {
                        return elem;
                    }
                    JavaTemplate.Matcher matcher = this.before2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitStatement(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.lang.Iterable forEach(..)", true), new UsesMethod("java.util.Collection remove(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SetStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.SetStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily call `Stream#distinct()` on an already-unique stream of elements.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream().distinct()").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{set:any(java.util.Set<T>)}.stream()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream distinct(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NewArrayListFromCollectionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.NewArrayListFromCollection`";
        }

        public String getDescription() {
            return "Prefer `ArrayList#ArrayList(Collection)` over the Guava alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Lists.newArrayList(#{collection:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"new java.util.ArrayList<>(#{collection:any(java.util.Collection<T>)})").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Lists");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Lists", Boolean.valueOf(true)), new UsesType("java.util.ArrayList", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Lists newArrayList(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionAsListRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionAsList`";
        }

        public String getDescription() {
            return "Prefer `ImmutableCollection#asList()` over the more verbose alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableList.copyOf(#{collection:any(com.google.common.collect.ImmutableCollection<T>)})").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("com.google.common.collect.ImmutableList", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableList copyOf(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionStream`";
        }

        public String getDescription() {
            return "Don't call `ImmutableCollection#asList()` if the result is going to be streamed; stream directly.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.stream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("java.util.Collection stream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionContainsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionContains`";
        }

        public String getDescription() {
            return "Don't call `ImmutableCollection#asList()` if `Collection#contains(Object)` is called on the result; call it directly.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().contains(#{elem:any(S)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.contains(#{elem:any(S)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("com.google.common.collect.ImmutableList contains(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionParallelStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionParallelStream`";
        }

        public String getDescription() {
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#parallelStream()` is called on the result; call it directly.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().parallelStream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.parallelStream()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("java.util.Collection parallelStream(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionToStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionToString`";
        }

        public String getDescription() {
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#toString()` is called on the result; call it directly.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toString()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.toString()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("java.util.AbstractCollection toString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionToArrayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionToArray`";
        }

        public String getDescription() {
            return "Prefer calling `Collection#toArray()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.toArray(new Object[#{size:any(int)}])").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.toArray(Object[]::new)").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toArray()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.toArray()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("com.google.common.collect.ImmutableCollection toArray(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection toArray(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionToArrayWithArrayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionToArrayWithArray`";
        }

        public String getDescription() {
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#toArray(Object[])`` is called on the result; call it directly.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toArray(#{array:any(S[])})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.toArray(#{array:any(S[])})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("com.google.common.collect.ImmutableCollection toArray(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableCollectionToArrayWithGeneratorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.ImmutableCollectionToArrayWithGenerator`";
        }

        public String getDescription() {
            return "Don't call `ImmutableCollection#asList()` if `ImmutableCollection#toArray(IntFunction)`} is called on the result; call it directly.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().toArray(#{generator:any(java.util.function.IntFunction<S[]>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.toArray(#{generator:any(java.util.function.IntFunction<S[]>)})").genericTypes(new String[]{"T", "S"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesType("java.util.function.IntFunction", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("java.util.Collection toArray(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionIteratorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionIterator`";
        }

        public String getDescription() {
            return "Prefer `Collection#iterator()` over more contrived or less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().iterator()").genericTypes(new String[]{"T"}).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{collection:any(com.google.common.collect.ImmutableCollection<T>)}.asList().iterator()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.iterator()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableCollection");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableCollection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableCollection asList(..)", true), new UsesMethod("com.google.common.collect.ImmutableList iterator(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.BaseStream iterator(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class OptionalFirstCollectionElementRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.OptionalFirstCollectionElement`";
        }

        public String getDescription() {
            return "Don't use the ternary operator to extract the first element of a possibly-empty `Collection` as an `Optional`, and (when applicable) prefer `Stream#findFirst()` over `Stream#findAny()` to communicate that the collection's first element (if any, according to iteration order) will be returned.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().findAny()").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.iterator().next())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{collection:any(java.util.List<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.get(0))").genericTypes(new String[]{"T"}).build();
                final JavaTemplate before1 = JavaTemplate.builder((String)"#{collection:any(java.util.SortedSet<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{collection}.first())").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().findFirst()").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitTernary(J.Ternary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.List");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.SortedSet");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitTernary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection isEmpty(..)", true), new UsesMethod("java.util.Collection iterator(..)", true), new UsesMethod("java.util.Iterator next(..)", true), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("java.util.Optional of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream findAny(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesMethod("java.util.List get(..)", true), new UsesMethod("java.util.List isEmpty(..)", true), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("java.util.Optional of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.SortedSet", Boolean.valueOf(true)), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("java.util.Optional of(..)", true), new UsesMethod("java.util.Set isEmpty(..)", true), new UsesMethod("java.util.SortedSet first(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class RemoveOptionalFirstNavigableSetElementRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.RemoveOptionalFirstNavigableSetElement`";
        }

        public String getDescription() {
            return "Avoid contrived constructions when extracting the first element from a possibly empty `NavigableSet`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{set:any(java.util.NavigableSet<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.of(#{set}.pollFirst())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{set:any(java.util.NavigableSet<T>)}.isEmpty() ? java.util.Optional.empty() : java.util.Optional.ofNullable(#{set}.pollFirst())").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{set:any(java.util.NavigableSet<T>)}.pollFirst())").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.NavigableSet", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.NavigableSet pollFirst(..)", true), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("java.util.Set isEmpty(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional of(..)", true), new UsesMethod("java.util.Optional ofNullable(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionForEachRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `CollectionRules.CollectionForEach`";
        }

        public String getDescription() {
            return "Prefer `Collection#forEach(Consumer)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().forEach(#{consumer:any(java.util.function.Consumer<? super T>)});").genericTypes(new String[]{"T"}).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.forEach(#{consumer:any(java.util.function.Consumer<? super T>)});").genericTypes(new String[]{"T"}).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream forEach(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

