/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableSortedMapRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableSortedMapRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableSortedMap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableSortedMapRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableSortedMapBuilderRecipe(), new ImmutableSortedMapNaturalOrderBuilderRecipe(), new ImmutableSortedMapReverseOrderBuilderRecipe(), new EmptyImmutableSortedMapRecipe(), new PairToImmutableSortedMapRecipe(), new EntryToImmutableSortedMapRecipe(), new IterableToImmutableSortedMapRecipe()});
    }

    @NullMarked
    public static class ImmutableSortedMapBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.ImmutableSortedMapBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#orderedBy(Comparator)` over the associated constructor.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableSortedMap.Builder<>(#{cmp:any(java.util.Comparator<K>)})").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.orderedBy(#{cmp:any(java.util.Comparator<K>)})").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder <constructor>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSortedMapNaturalOrderBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.ImmutableSortedMapNaturalOrderBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#naturalOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.orderedBy(java.util.Comparator.<K>naturalOrder())").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.naturalOrder()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSortedMap", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap orderedBy(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableSortedMapReverseOrderBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.ImmutableSortedMapReverseOrderBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#reverseOrder()` over the alternative that requires explicitly providing the `Comparator`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.orderedBy(java.util.Comparator.<K>reverseOrder())").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.reverseOrder()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSortedMap", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap orderedBy(..)", true), new UsesMethod("java.util.Comparator reverseOrder(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmptyImmutableSortedMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.EmptyImmutableSortedMap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#of()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().buildOrThrow()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.of()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSortedMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PairToImmutableSortedMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.PairToImmutableSortedMap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#of(Object, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().put(#{key:any(K)}, #{value:any(V)}).buildOrThrow()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.of(#{key:any(K)}, #{value:any(V)})").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSortedMap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder put(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EntryToImmutableSortedMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.EntryToImmutableSortedMap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#of(Object, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).buildOrThrow()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap(java.util.Comparator.naturalOrder(), java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSortedMap", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder put(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap toImmutableSortedMap(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IterableToImmutableSortedMapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableSortedMapRules.IterableToImmutableSortedMap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableSortedMap#copyOf(Iterable)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)}, java.util.Comparator.naturalOrder())").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.util.Map<? extends K, ? extends V>)}.entrySet())").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().putAll(#{iterable:any(java.util.Map<? extends K, ? extends V>)}).buildOrThrow()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K,? extends V>>)}, java.util.Comparator.naturalOrder())").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.<K, V>naturalOrder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K,? extends V>>)}).buildOrThrow()").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0$2 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K,? extends V>>)}).collect(com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap(java.util.Comparator.<K>naturalOrder(), java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before1 = JavaTemplate.builder((String)"#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K,? extends V>>)}.stream().collect(com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap(java.util.Comparator.naturalOrder(), java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableSortedMap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K,? extends V>>)})").genericTypes(new String[]{"K extends java.lang.Comparable<? super K>", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        this.maybeRemoveImport("java.util.Map");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMap");
                        this.maybeRemoveImport("java.util.Map");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableSortedMap.toImmutableSortedMap");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableSortedMap", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSortedMap copyOf(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder putAll(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap copyOf(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap copyOf(..)", true), new UsesMethod("java.util.Map entrySet(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMap", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap naturalOrder(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableSortedMap.Builder putAll(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap toImmutableSortedMap(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableSortedMap toImmutableSortedMap(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

