/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.customRecipes;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public class ChangePropertyKeyWithCaseChange
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename.")
    String oldPropertyKey;
    @Option(displayName="New prefix before any group", description="The prefix to be replaced with.")
    String newPrefix;
    @Option(displayName="Exclusions", description="Regexp for exclusions", example="camel.springboot.main-run-controller")
    List<String> exclusions = new ArrayList<String>();

    public String getDisplayName() {
        return "Change prefix of property with Camel case";
    }

    public String getDescription() {
        return "Change prefix of property with Camel case";
    }

    public PropertiesVisitor<ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            public Properties visitEntry(Properties.Entry entry, ExecutionContext p) {
                for (String exclusion : ChangePropertyKeyWithCaseChange.this.exclusions) {
                    if (!entry.getKey().equals(exclusion)) continue;
                    return super.visitEntry(entry, (Object)p);
                }
                if (entry.getKey().matches(ChangePropertyKeyWithCaseChange.this.oldPropertyKey)) {
                    entry = entry.withKey(this.getKey(entry)).withPrefix(entry.getPrefix());
                }
                return super.visitEntry(entry, (Object)p);
            }

            private String getKey(Properties.Entry entry) {
                return ChangePropertyKeyWithCaseChange.this.newPrefix + entry.getKey().replaceFirst(ChangePropertyKeyWithCaseChange.this.oldPropertyKey, "$1").substring(0, 1).toLowerCase() + entry.getKey().replaceFirst(ChangePropertyKeyWithCaseChange.this.oldPropertyKey, "$1").substring(1);
            }
        };
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKeyWithCaseChange)) {
            return false;
        }
        ChangePropertyKeyWithCaseChange other = (ChangePropertyKeyWithCaseChange)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldPropertyKey = this.oldPropertyKey;
        String other$oldPropertyKey = other.oldPropertyKey;
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPrefix = this.newPrefix;
        String other$newPrefix = other.newPrefix;
        if (this$newPrefix == null ? other$newPrefix != null : !this$newPrefix.equals(other$newPrefix)) {
            return false;
        }
        List<String> this$exclusions = this.exclusions;
        List<String> other$exclusions = other.exclusions;
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKeyWithCaseChange;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldPropertyKey = this.oldPropertyKey;
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPrefix = this.newPrefix;
        result = result * 59 + ($newPrefix == null ? 43 : $newPrefix.hashCode());
        List<String> $exclusions = this.exclusions;
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }

    @Generated
    public ChangePropertyKeyWithCaseChange() {
    }

    @Generated
    public ChangePropertyKeyWithCaseChange(String oldPropertyKey, String newPrefix, List<String> exclusions) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPrefix = newPrefix;
        this.exclusions = exclusions;
    }

    @Generated
    public void setOldPropertyKey(String oldPropertyKey) {
        this.oldPropertyKey = oldPropertyKey;
    }

    @Generated
    public void setNewPrefix(String newPrefix) {
        this.newPrefix = newPrefix;
    }

    @Generated
    public void setExclusions(List<String> exclusions) {
        this.exclusions = exclusions;
    }
}

