/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJInstantRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to AssertJ assertions over `Instant`s";
    }

    public String getDescription() {
        return "These rules simplify and improve the readability of tests by using `Instant`-specific\n AssertJ assertion methods instead of generic assertions.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJInstantRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatIsAfterRecipe(), new AssertThatIsBeforeOrEqualToRecipe(), new AssertThatIsBeforeRecipe(), new AssertThatIsAfterOrEqualToRecipe(), new AssertThatIsBetweenRecipe(), new AssertThatIsStrictlyBetweenRecipe()});
    }

    @NullMarked
    public static class AssertThatIsAfterRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJInstantRules.AssertThatIsAfter`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsAfter {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isAfter(other)).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isAfter(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isAfter(#{other:any(java.time.Instant)})).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfter(#{other:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.time.Instant isAfter(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsBeforeOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJInstantRules.AssertThatIsBeforeOrEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsBeforeOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isAfter(other)).isFalse();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isBeforeOrEqualTo(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isAfter(#{other:any(java.time.Instant)})).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBeforeOrEqualTo(#{other:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.time.Instant isAfter(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsBeforeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJInstantRules.AssertThatIsBefore`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsBefore {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isBefore(other)).isTrue();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isBefore(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isBefore(#{other:any(java.time.Instant)})).isTrue()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBefore(#{other:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.time.Instant isBefore(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsAfterOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJInstantRules.AssertThatIsAfterOrEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsAfterOrEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(Instant actual, Instant other) {\n        return assertThat(actual.isBefore(other)).isFalse();\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant other) {\n        return assertThat(actual).isAfterOrEqualTo(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}.isBefore(#{other:any(java.time.Instant)})).isFalse()").bindType("org.assertj.core.api.AbstractBooleanAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractBooleanAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfterOrEqualTo(#{other:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("java.time.Instant isBefore(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsBetweenRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJInstantRules.AssertThatIsBetween`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsBetween {\n    \n    @BeforeTemplate\n    AbstractInstantAssert<?> before(Instant actual, Instant start, Instant end) {\n        return Refaster.anyOf(assertThat(actual).isAfterOrEqualTo(start).isBeforeOrEqualTo(end), assertThat(actual).isBeforeOrEqualTo(end).isAfterOrEqualTo(start));\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant start, Instant end) {\n        return assertThat(actual).isBetween(start, end);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfterOrEqualTo(#{start:any(java.time.Instant)}).isBeforeOrEqualTo(#{end:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBeforeOrEqualTo(#{end:any(java.time.Instant)}).isAfterOrEqualTo(#{start:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractInstantAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractInstantAssert isAfterOrEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractInstantAssert isBeforeOrEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatIsStrictlyBetweenRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJInstantRules.AssertThatIsStrictlyBetween`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatIsStrictlyBetween {\n    \n    @BeforeTemplate\n    AbstractInstantAssert<?> before(Instant actual, Instant start, Instant end) {\n        return Refaster.anyOf(assertThat(actual).isAfter(start).isBefore(end), assertThat(actual).isBefore(end).isAfter(start));\n    }\n    \n    @AfterTemplate\n    AbstractInstantAssert<?> after(Instant actual, Instant start, Instant end) {\n        return assertThat(actual).isStrictlyBetween(start, end);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isAfter(#{start:any(java.time.Instant)}).isBefore(#{end:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isStrictlyBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isBefore(#{end:any(java.time.Instant)}).isAfter(#{start:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{actual:any(java.time.Instant)}).isStrictlyBetween(#{start:any(java.time.Instant)}, #{end:any(java.time.Instant)})").bindType("org.assertj.core.api.AbstractInstantAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Instant", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractInstantAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractInstantAssert isAfter(..)", true), new UsesMethod("org.assertj.core.api.AbstractInstantAssert isBefore(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

