/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJOptionalRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJOptionalRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJOptionalRules`.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJOptionalRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatOptionalRecipe(), new AbstractOptionalAssertIsPresentRecipe(), new AssertThatOptionalIsPresentRecipe(), new AbstractOptionalAssertIsEmptyRecipe(), new AssertThatOptionalIsEmptyRecipe(), new AbstractOptionalAssertHasValueRecipe(), new AbstractOptionalAssertContainsSameRecipe(), new AssertThatOptionalHasValueMatchingRecipe()});
    }

    @NullMarked
    public static class AssertThatOptionalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AssertThatOptional`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptional<T> {\n    \n    @BeforeTemplate\n    ObjectAssert<T> before(Optional<T> optional) {\n        return assertThat(optional.orElseThrow());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, T> after(Optional<T> optional) {\n        return assertThat(optional).get();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.orElseThrow())").bindType("org.assertj.core.api.ObjectAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.ObjectAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).get()").bindType("org.assertj.core.api.AbstractObjectAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ObjectAssert", Boolean.valueOf(true)), new UsesMethod("java.util.Optional orElseThrow(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractOptionalAssertIsPresentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertIsPresent`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertIsPresent<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert) {\n        return Refaster.anyOf(optionalAssert.isNotEmpty(), optionalAssert.isNotEqualTo(Optional.empty()));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert) {\n        return optionalAssert.isPresent();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isNotEmpty()").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent()").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isNotEqualTo(java.util.Optional.empty())").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent()").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractOptionalAssert", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractOptionalAssert isNotEmpty(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isNotEqualTo(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalIsPresentRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AssertThatOptionalIsPresent`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalIsPresent<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Optional<T> optional) {\n        return Refaster.anyOf(assertThat(optional.isPresent()).isTrue(), assertThat(optional.isEmpty()).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalAssert<T> after(Optional<T> optional) {\n        return assertThat(optional).isPresent();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isPresent()).isTrue()").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isPresent()").bindType("org.assertj.core.api.OptionalAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isEmpty()).isFalse()").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isPresent()").bindType("org.assertj.core.api.OptionalAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional isEmpty(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional isPresent(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractOptionalAssertIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertIsEmpty<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert) {\n        return Refaster.anyOf(optionalAssert.isNotPresent(), optionalAssert.isEqualTo(Optional.empty()));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert) {\n        return optionalAssert.isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isNotPresent()").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEmpty()").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEqualTo(java.util.Optional.empty())").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEmpty()").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractOptionalAssert", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractOptionalAssert isNotPresent(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional empty(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AssertThatOptionalIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalIsEmpty<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(Optional<T> optional) {\n        return Refaster.anyOf(assertThat(optional.isEmpty()).isTrue(), assertThat(optional.isPresent()).isFalse());\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalAssert<T> after(Optional<T> optional) {\n        return assertThat(optional).isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isEmpty()).isTrue()").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isEmpty()").bindType("org.assertj.core.api.OptionalAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.isPresent()).isFalse()").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).isEmpty()").bindType("org.assertj.core.api.OptionalAssert<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional isEmpty(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Optional isPresent(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractOptionalAssertHasValueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertHasValue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertHasValue<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return Refaster.anyOf(optionalAssert.get().isEqualTo(value), optionalAssert.isEqualTo(Optional.of(value)), optionalAssert.contains(value), optionalAssert.isPresent().hasValue(value));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return optionalAssert.hasValue(value);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.get().isEqualTo(#{value:any(T)})").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isEqualTo(java.util.Optional.of(#{value:any(T)}))").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.contains(#{value:any(T)})").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent().hasValue(#{value:any(T)})").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.hasValue(#{value:any(T)})").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractOptionalAssert", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractOptionalAssert contains(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.AbstractOptionalAssert get(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractOptionalAssert hasValue(..)", true), new UsesMethod("org.assertj.core.api.AbstractOptionalAssert isPresent(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional of(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isEqualTo(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractOptionalAssertContainsSameRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AbstractOptionalAssertContainsSame`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractOptionalAssertContainsSame<T> {\n    \n    @BeforeTemplate\n    AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return Refaster.anyOf(optionalAssert.get().isSameAs(value), optionalAssert.isPresent().isSameAs(value));\n    }\n    \n    @AfterTemplate\n    AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert, T value) {\n        return optionalAssert.containsSame(value);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.get().isSameAs(#{value:any(T)})").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.containsSame(#{value:any(T)})").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.isPresent().isSameAs(#{value:any(T)})").bindType("org.assertj.core.api.AbstractAssert<?, ?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{optionalAssert:any(org.assertj.core.api.AbstractOptionalAssert<?, T>)}.containsSame(#{value:any(T)})").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractOptionalAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractAssert isSameAs(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractOptionalAssert get(..)", true), new UsesMethod("org.assertj.core.api.AbstractOptionalAssert isPresent(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalHasValueMatchingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJOptionalRules.AssertThatOptionalHasValueMatching`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalHasValueMatching<T> {\n    \n    @BeforeTemplate\n    AbstractOptionalAssert<?, T> before(Optional<T> optional, Predicate<? super T> predicate) {\n        return assertThat(optional.filter(predicate)).isPresent();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractObjectAssert<?, T> after(Optional<T> optional, Predicate<? super T> predicate) {\n        return assertThat(optional).get().matches(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}.filter(#{predicate:any(java.util.function.Predicate<? super T>)})).isPresent()").bindType("org.assertj.core.api.AbstractOptionalAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractOptionalAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.Optional<T>)}).get().matches(#{predicate:any(java.util.function.Predicate<? super T>)})").bindType("org.assertj.core.api.AbstractObjectAssert<?, T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractOptionalAssert", Boolean.valueOf(true)), new UsesMethod("java.util.Optional filter(..)", true), new UsesMethod("org.assertj.core.api.AbstractOptionalAssert isPresent(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

