/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.weblogic.rewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class OutputRecipeVersion
extends Recipe {
    public String getDisplayName() {
        return "Output Recipe Version";
    }

    public String getDescription() {
        return "Displays the version of the recipe after it runs.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                OutputRecipeVersion.this.displayRecipeInfo();
                return d;
            }
        };
    }

    private void displayRecipeInfo() {
        Package pkg = OutputRecipeVersion.class.getPackage();
        String title = pkg.getImplementationTitle();
        String version = pkg.getImplementationVersion();
        if (title == null) {
            title = "Title information not available";
        }
        if (version == null) {
            version = "Version information not available";
        }
        System.out.println(String.format("--- Running recipe(s) from %s:%s", title, version));
    }
}

