/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelJavaVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCamelJavaVisitor.class);
    private static final Map<String, MethodMatcher> methodMatchers = new HashMap<String, MethodMatcher>();
    private static final Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public final J.Import visitImport(J.Import _import, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitImport(_import, context), _import, context);
    }

    public final J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitClassDeclaration(classDecl, context), classDecl, context);
    }

    public final J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitFieldAccess(fieldAccess, context), fieldAccess, context);
    }

    public final J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitMethodDeclaration(method, context), method, context);
    }

    public final J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitMethodInvocation(method, context), method, context);
    }

    public final J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitAnnotation(annotation, context), annotation, context);
    }

    public final J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitNewClass(newClass, context), newClass, context);
    }

    public final J.Literal visitLiteral(J.Literal literal, ExecutionContext context) {
        return this.executeVisitWithCatch(() -> this.doVisitLiteral(literal, context), literal, context);
    }

    protected J.Import doVisitImport(J.Import _import, ExecutionContext context) {
        return super.visitImport(_import, (Object)context);
    }

    protected J.ClassDeclaration doVisitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
        return super.visitClassDeclaration(classDecl, (Object)context);
    }

    protected J.FieldAccess doVisitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
        return super.visitFieldAccess(fieldAccess, (Object)context);
    }

    protected J.MethodDeclaration doVisitMethodDeclaration(J.MethodDeclaration method, ExecutionContext context) {
        return super.visitMethodDeclaration(method, (Object)context);
    }

    protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
        return super.visitMethodInvocation(method, (Object)context);
    }

    protected J.Annotation doVisitAnnotation(J.Annotation annotation, ExecutionContext context) {
        return super.visitAnnotation(annotation, (Object)context);
    }

    protected J.NewClass doVisitNewClass(J.NewClass newClass, ExecutionContext context) {
        return super.visitNewClass(newClass, (Object)context);
    }

    protected J.Literal doVisitLiteral(J.Literal literal, ExecutionContext context) {
        return super.visitLiteral(literal, (Object)context);
    }

    protected <T extends J> T executeVisitWithCatch(Supplier<T> visitMethod, T origValue, ExecutionContext context) {
        try {
            return (T)((J)visitMethod.get());
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Internal error detected in %s, recipe is skipped.", ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            return origValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodMatcher getMethodMatcher(String signature) {
        Map<String, MethodMatcher> map = methodMatchers;
        synchronized (map) {
            MethodMatcher matcher = methodMatchers.get(signature);
            if (matcher == null) {
                matcher = new MethodMatcher(signature);
                methodMatchers.put(signature, matcher);
            }
            return matcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern getPattern(String pattern) {
        Map<String, Pattern> map = patterns;
        synchronized (map) {
            Pattern p = patterns.get(pattern);
            if (p == null) {
                p = Pattern.compile(pattern);
                patterns.put(pattern, p);
            }
            return p;
        }
    }
}

