/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;

@SdkInternalApi
public class S3TmAddComments
extends Recipe {
    private static final Pattern S3_TM = Pattern.compile("software.amazon.awssdk.transfer.s3.S3TransferManager");
    private static final Pattern S3_CLIENT = Pattern.compile("software.amazon.awssdk.services.s3.S3Client");
    private static final MethodMatcher COPY = S3TransformUtils.v2TmMethodMatcher("copy(..)");
    private static final MethodMatcher DOWNLOAD = S3TransformUtils.v2TmMethodMatcher(String.format("download(%sGetObjectRequest, java.io.File, %sinternal.S3ProgressListener, ..)", "software.amazon.awssdk.services.s3.model.", "com.amazonaws.services.s3.transfer."));
    private static final MethodMatcher DOWNLOAD_DIRECTORY = S3TransformUtils.v2TmMethodMatcher("downloadDirectory(..)");
    private static final MethodMatcher UPLOAD = S3TransformUtils.v2TmMethodMatcher("upload(..)");
    private static final MethodMatcher UPLOAD_DIRECTORY = S3TransformUtils.v2TmMethodMatcher("uploadDirectory(..)");

    public String getDisplayName() {
        return "Add imports and comments to unsupported S3 transfer manager transforms.";
    }

    public String getDescription() {
        return "Add imports and comments to unsupported S3 transfer manager transforms.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (COPY.matches((MethodCall)method) && (method.getArguments().size() == 2 || method.getArguments().size() == 3)) {
                String comment = "Migration for TransferStateChangeListener is not supported by the migration tool. Please manually migrate the code using TransferListener in v2";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (DOWNLOAD.matches((MethodCall)method)) {
                String comment = "Migration for S3ProgressListener is not supported by the migration tool. Please manually migrate the code using TransferListener in v2";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (DOWNLOAD_DIRECTORY.matches((MethodCall)method) && method.getArguments().size() > 3) {
                String comment = "Migration for KeyFilter is not supported by the migration tool. Please manually migrate the code using DownloadFilter in v2";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (UPLOAD.matches((MethodCall)method) && method.getArguments().size() == 4) {
                String comment = "Migration for InputStream and ObjectMetadata as argument for upload is not supported by the migration tool.";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (UPLOAD.matches((MethodCall)method) && method.getArguments().size() == 2) {
                String comment = "Migration for S3ProgressListener is not supported by the migration tool. Please manually migrate the code using TransferListener in v2";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            if (UPLOAD_DIRECTORY.matches((MethodCall)method) && method.getArguments().size() > 4) {
                String comment = "Migration for ObjectMetadataProvider as argument for uploadDirectory is not supported by the migration tool.";
                return (J.MethodInvocation)method.withComments(S3TransformUtils.createComments(comment));
            }
            return method;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            JavaType type = newClass.getType();
            if (!(type instanceof JavaType.FullyQualified)) {
                return newClass;
            }
            if (type.isAssignableFrom(S3_TM) && !newClass.getArguments().isEmpty() && ((Expression)newClass.getArguments().get(0)).getType() != null && ((Expression)newClass.getArguments().get(0)).getType().isAssignableFrom(S3_CLIENT)) {
                String comment = "S3TransferManager requires S3AsyncClient in v2. Please create a new S3AsyncClient instance for v2 S3TransferManager.";
                return (J.NewClass)newClass.withComments(S3TransformUtils.createComments(comment));
            }
            return newClass;
        }
    }
}

