/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableListMultimapRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableListMultimapRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableListMultimap`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableListMultimapRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableListMultimapBuilderRecipe(), new EmptyImmutableListMultimapRecipe(), new PairToImmutableListMultimapRecipe(), new EntryToImmutableListMultimapRecipe(), new IterableToImmutableListMultimapRecipe(), new TransformMultimapValuesToImmutableListMultimap2Recipe()});
    }

    @NullMarked
    public static class ImmutableListMultimapBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableListMultimapRules.ImmutableListMultimapBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableListMultimap#builder()` over the associated constructor on constructions that produce a less-specific type.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableListMultimap.Builder<>()").bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.builder()").bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableMultimap.Builder<>()").bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.builder()").bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.builder()").bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.builder()").bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableListMultimap.Builder<>()").bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.builder()").bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableMultimap.Builder<>()").bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.builder()").bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.builder()").bindType("com.google.common.collect.ImmutableMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.builder()").bindType("com.google.common.collect.ImmutableListMultimap.Builder<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder <init>(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultimap.Builder <init>(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultimap builder(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmptyImmutableListMultimapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableListMultimapRules.EmptyImmutableListMultimap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableListMultimap#of()` over more contrived or less-specific alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.<K, V>builder().build()").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.of()").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.of()").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.of()").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableMultimap of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PairToImmutableListMultimapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableListMultimapRules.PairToImmutableListMultimap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableListMultimap#of(Object, Object)` over more contrived or less-specific alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.<K, V>builder().put(#{key:any(K)}, #{value:any(V)}).build()").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.of(#{key:any(K)}, #{value:any(V)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.of(#{key:any(K)}, #{value:any(V)})").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.of(#{key:any(K)}, #{value:any(V)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableMultimap of(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder put(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EntryToImmutableListMultimapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableListMultimapRules.EntryToImmutableListMultimap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableListMultimap#of(Object, Object)` over more contrived or less-specific alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.<K, V>builder().put(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).build()").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}).collect(com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.of(#{entry:any(java.util.Map.Entry<? extends K, ? extends V>)}.getKey(), #{entry}.getValue())").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableListMultimap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder put(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap toImmutableListMultimap(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IterableToImmutableListMultimapRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableListMultimapRules.IterableToImmutableListMultimap`";
        }

        public String getDescription() {
            return "Prefer `ImmutableListMultimap#copyOf(Iterable)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before0$2;
                JavaTemplate before1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}.entries())").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        this.maybeRemoveImport("com.google.common.collect.Multimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.<K, V>builder().putAll(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}).build()").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        this.maybeRemoveImport("com.google.common.collect.Multimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)})").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        this.maybeRemoveImport("com.google.common.collect.Multimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.copyOf(#{iterable:any(com.google.common.collect.Multimap<? extends K, ? extends V>)}.entries())").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        this.maybeRemoveImport("com.google.common.collect.Multimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$0 == null) {
                        this.before0$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.<K, V>builder().putAll(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).build()").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$1 == null) {
                        this.before0$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)}).collect(com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$2 == null) {
                        this.before0$2 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"#{iterable:any(java.util.Collection<? extends java.util.Map.Entry<? extends K, ? extends V>>)}.stream().collect(com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap(java.util.Map.Entry::getKey, java.util.Map.Entry::getValue))").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.toImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(#{iterable:any(java.lang.Iterable<? extends java.util.Map.Entry<? extends K, ? extends V>>)})").bindType("com.google.common.collect.ImmutableListMultimap<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder putAll(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder build(..)", true), new UsesMethod("com.google.common.collect.ImmutableListMultimap.Builder putAll(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap copyOf(..)", true), new UsesMethod("com.google.common.collect.Multimap entries(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap toImmutableListMultimap(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultimap copyOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultimap copyOf(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultimap copyOf(..)", true), new UsesMethod("com.google.common.collect.Multimap entries(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap toImmutableListMultimap(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TransformMultimapValuesToImmutableListMultimap2Recipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableListMultimapRules.TransformMultimapValuesToImmutableListMultimap2`";
        }

        public String getDescription() {
            return "Prefer creating an immutable copy of the result of `Multimaps#transformValues(Multimap, com.google.common.base.Function)` over creating and directly collecting a stream.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0;
                JavaTemplate before1;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{multimap:any(com.google.common.collect.Multimap<K, V1>)}.asMap().entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map.Entry");
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map.Entry");
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.ListMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map.Entry");
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.List");
                        this.maybeRemoveImport("com.google.common.collect.ListMultimap");
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1 == null) {
                        this.before1 = JavaTemplate.builder((String)"com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.SetMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map.Entry");
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.Set");
                        this.maybeRemoveImport("com.google.common.collect.SetMultimap");
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"com.google.common.collect.Multimaps.asMap(#{multimap:any(com.google.common.collect.SortedSetMultimap<K, V1>)}).entrySet().stream().collect(com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap(java.util.Map.Entry::getKey, (e)->e.getValue().stream().map(#{transformation:any(java.util.function.Function<? super V1, ? extends V2>)})))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Map.Entry");
                        this.maybeRemoveImport("java.util.Map");
                        this.maybeRemoveImport("java.util.SortedSet");
                        this.maybeRemoveImport("com.google.common.collect.SortedSetMultimap");
                        this.maybeRemoveImport("java.util.function.Function");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableListMultimap.flatteningToImmutableListMultimap");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableListMultimap.copyOf(com.google.common.collect.Multimaps.transformValues(#{multimap:any(com.google.common.collect.Multimap<K, V1>)}, #{transformation:any(com.google.common.base.Function<? super V1, ? extends V2>)}))").bindType("com.google.common.collect.ImmutableListMultimap<K, V2>").genericTypes(new String[]{"K", "V1", "V2"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableListMultimap", Boolean.valueOf(true)), new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("java.util.Map.Entry", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableListMultimap flatteningToImmutableListMultimap(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Map entrySet(..)", true), new UsesMethod("java.util.Map.Entry getValue(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream map(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ListMultimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimaps", Boolean.valueOf(true)), new UsesType("java.util.List", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimaps asMap(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("com.google.common.collect.Multimaps", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimaps asMap(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimap", Boolean.valueOf(true)), new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimap asMap(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimaps", Boolean.valueOf(true)), new UsesType("com.google.common.collect.SetMultimap", Boolean.valueOf(true)), new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimaps asMap(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multimaps", Boolean.valueOf(true)), new UsesType("com.google.common.collect.SortedSetMultimap", Boolean.valueOf(true)), new UsesType("java.util.SortedSet", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Multimaps asMap(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }
}

