/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel40.java;

import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelJavaVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public final class CamelHttpRecipe
extends Recipe {
    private static final String SET_CREDENTIALS = "org.apache.http.impl.client.BasicCredentialsProvider setCredentials(..)";
    private static final String SCOPE_ANY = "AuthScope.ANY";

    public String getDisplayName() {
        return "Camel Http Extension changes";
    }

    public String getDescription() {
        return "Camel Http Extension changes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor("org.apache.http..*", new AbstractCamelJavaVisitor(){

            @Override
            protected J.Import doVisitImport(J.Import _import, ExecutionContext ctx) {
                this.doAfterVisit(new ChangeType("org.apache.http.HttpHost", "org.apache.hc.core5.http.HttpHost", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.client.protocol.HttpClientContext", "org.apache.hc.client5.http.protocol.HttpClientContext", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.protocol.HttpContext", "org.apache.hc.core5.http.protocol.HttpContext", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.impl.auth.BasicScheme", "org.apache.hc.client5.http.impl.auth.BasicScheme", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.impl.client.BasicAuthCache", "org.apache.hc.client5.http.impl.auth.BasicAuthCache", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.impl.client.BasicCredentialsProvider", "org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.auth.AuthScope", "org.apache.hc.client5.http.auth.AuthScope", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.auth.UsernamePasswordCredentials", "org.apache.hc.client5.http.auth.UsernamePasswordCredentials", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.conn.ssl.NoopHostnameVerifier", "org.apache.hc.client5.http.conn.ssl.NoopHostnameVerifier", Boolean.valueOf(true)).getVisitor());
                return super.doVisitImport(_import, ctx);
            }

            @Override
            protected J.FieldAccess doVisitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.FieldAccess f = super.doVisitFieldAccess(fieldAccess, ctx);
                if ("ANY".equals(f.getSimpleName()) && "org.apache.http.auth.AuthScope".equals(f.getType().toString())) {
                    JavaTemplate.Builder templateBuilder = JavaTemplate.builder((String)"new AuthScope(null, -1)");
                    J.NewClass nc = (J.NewClass)templateBuilder.build().apply(this.updateCursor((Tree)fieldAccess), f.getCoordinates().replace(), new Object[0]).withPrefix(f.getPrefix());
                    this.getCursor().putMessage("authScopeNewClass", (Object)nc);
                }
                return f;
            }

            public @Nullable J postVisit(J tree, ExecutionContext ctx) {
                J j = (J)super.postVisit((Tree)tree, (Object)ctx);
                J.NewClass newClass = (J.NewClass)this.getCursor().getMessage("authScopeNewClass");
                if (newClass != null) {
                    this.maybeAddImport("org.apache.hc.client5.http.auth.AuthScope", null, false);
                    return newClass;
                }
                return j;
            }
        });
    }

    @Generated
    public CamelHttpRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CamelHttpRecipe()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelHttpRecipe)) {
            return false;
        }
        CamelHttpRecipe other = (CamelHttpRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CamelHttpRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

