/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableMultisetRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableMultisetRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableMultiset`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableMultisetRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableMultisetBuilderRecipe(), new EmptyImmutableMultisetRecipe(), new IterableToImmutableMultisetRecipe(), new StreamToImmutableMultisetRecipe()});
    }

    @NullMarked
    public static class ImmutableMultisetBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMultisetRules.ImmutableMultisetBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMultiset#builder()` over the associated constructor.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableMultiset.Builder<>()").bindType("com.google.common.collect.ImmutableMultiset.Builder<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.builder()").bindType("com.google.common.collect.ImmutableMultiset.Builder<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder <init>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmptyImmutableMultisetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMultisetRules.EmptyImmutableMultiset`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMultiset#of()` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.<T>builder().build()").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.of()").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.<T>empty().collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.of()").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultiset", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableMultiset builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream empty(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IterableToImmutableMultisetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMultisetRules.IterableToImmutableMultiset`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMultiset#copyOf(Iterable)` and variants over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before0$0;
                JavaTemplate before0$1;
                JavaTemplate before1$0;
                JavaTemplate before1$1;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.<T>builder().add(#{iterable:any(T[])}).build()").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Arrays.stream(#{iterable:any(T[])}).collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Arrays");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$0 == null) {
                        this.before0$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.<T>builder().addAll(#{iterable:any(java.util.Iterator<T>)}).build()").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Iterator");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0$1 == null) {
                        this.before0$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.util.Iterator<T>)}).collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("java.util.Iterator");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1$0 == null) {
                        this.before1$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.<T>builder().addAll(#{iterable:any(java.lang.Iterable<T>)}).build()").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before1$1 == null) {
                        this.before1$1 = JavaTemplate.builder((String)"com.google.common.collect.Streams.stream(#{iterable:any(java.lang.Iterable<T>)}).collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before1$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"#{iterable:any(java.util.Collection<T>)}.stream().collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collection");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableMultiset.toImmutableMultiset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{iterable:any(java.lang.Iterable<T>)})").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultiset", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableMultiset builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder add(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableMultiset builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder addAll(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true), new UsesMethod("com.google.common.collect.Streams stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Arrays", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true), new UsesMethod("java.util.Arrays stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset toImmutableMultiset(..)", true), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Iterator", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder addAll(..)", true), new UsesMethod("com.google.common.collect.ImmutableMultiset.Builder build(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StreamToImmutableMultisetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableMultisetRules.StreamToImmutableMultiset`";
        }

        public String getDescription() {
            return "Prefer `ImmutableMultiset#toImmutableMultiset()` over less idiomatic alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableMultiset.copyOf(#{stream:any(java.util.stream.Stream<T>)}.iterator())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.Stream<T>)}.collect(com.google.common.collect.ImmutableMultiset.toImmutableMultiset())").bindType("com.google.common.collect.ImmutableMultiset<T>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableMultiset", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableMultiset copyOf(..)", true), new UsesMethod("java.util.stream.BaseStream iterator(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

