/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.math.BigDecimal;

final class BigDecimalRules {
    private BigDecimalRules() {
    }

    static final class BigDecimalSignumIsNegative {
        BigDecimalSignumIsNegative() {
        }

        boolean before(BigDecimal value) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{value.compareTo(BigDecimal.ZERO) < 0, BigDecimal.ZERO.compareTo(value) > 0, value.signum() < 0, value.signum() <= -1});
        }

        boolean after(BigDecimal value) {
            return value.signum() == -1;
        }
    }

    static final class BigDecimalSignumIsPositive {
        BigDecimalSignumIsPositive() {
        }

        boolean before(BigDecimal value) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{value.compareTo(BigDecimal.ZERO) > 0, BigDecimal.ZERO.compareTo(value) < 0, value.signum() > 0, value.signum() >= 1});
        }

        boolean after(BigDecimal value) {
            return value.signum() == 1;
        }
    }

    static final class BigDecimalSignumIsZero {
        BigDecimalSignumIsZero() {
        }

        boolean before(BigDecimal value) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{value.compareTo(BigDecimal.ZERO) == 0, BigDecimal.ZERO.compareTo(value) == 0});
        }

        boolean after(BigDecimal value) {
            return value.signum() == 0;
        }
    }

    static final class BigDecimalValueOf {
        BigDecimalValueOf() {
        }

        BigDecimal before(double value) {
            return new BigDecimal(value);
        }

        BigDecimal after(double value) {
            return BigDecimal.valueOf(value);
        }
    }

    static final class BigDecimalTen {
        BigDecimalTen() {
        }

        BigDecimal before() {
            return (BigDecimal)Refaster.anyOf((Object[])new BigDecimal[]{BigDecimal.valueOf(10L), new BigDecimal("10")});
        }

        BigDecimal after() {
            return BigDecimal.TEN;
        }
    }

    static final class BigDecimalOne {
        BigDecimalOne() {
        }

        BigDecimal before() {
            return (BigDecimal)Refaster.anyOf((Object[])new BigDecimal[]{BigDecimal.valueOf(1L), new BigDecimal("1")});
        }

        BigDecimal after() {
            return BigDecimal.ONE;
        }
    }

    static final class BigDecimalZero {
        BigDecimalZero() {
        }

        BigDecimal before() {
            return (BigDecimal)Refaster.anyOf((Object[])new BigDecimal[]{BigDecimal.valueOf(0L), new BigDecimal("0")});
        }

        BigDecimal after() {
            return BigDecimal.ZERO;
        }
    }
}

