/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import java.util.OptionalLong;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import java.util.stream.Stream;

final class LongStreamRules {
    private LongStreamRules() {
    }

    static final class LongStreamTakeWhile {
        LongStreamTakeWhile() {
        }

        LongStream before(LongStream stream, LongPredicate predicate) {
            return stream.takeWhile(predicate).filter(predicate);
        }

        LongStream after(LongStream stream, LongPredicate predicate) {
            return stream.takeWhile(predicate);
        }
    }

    static abstract class LongStreamAllMatch2 {
        LongStreamAllMatch2() {
        }

        abstract boolean test(long var1);

        boolean before(LongStream stream) {
            return stream.noneMatch(e -> !this.test(e));
        }

        boolean after(LongStream stream) {
            return stream.allMatch(e -> this.test(e));
        }
    }

    static final class LongStreamAllMatch {
        LongStreamAllMatch() {
        }

        boolean before(LongStream stream, LongPredicate predicate) {
            return stream.noneMatch(predicate.negate());
        }

        boolean after(LongStream stream, LongPredicate predicate) {
            return stream.allMatch(predicate);
        }
    }

    static final class LongStreamAnyMatch {
        LongStreamAnyMatch() {
        }

        boolean before(LongStream stream, LongPredicate predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.noneMatch(predicate), stream.filter(predicate).findAny().isPresent()});
        }

        boolean after(LongStream stream, LongPredicate predicate) {
            return stream.anyMatch(predicate);
        }
    }

    static abstract class LongStreamNoneMatch2 {
        LongStreamNoneMatch2() {
        }

        abstract boolean test(long var1);

        boolean before(LongStream stream) {
            return stream.allMatch(e -> !this.test(e));
        }

        boolean after(LongStream stream) {
            return stream.noneMatch(e -> this.test(e));
        }
    }

    static final class LongStreamNoneMatch {
        LongStreamNoneMatch() {
        }

        boolean before(LongStream stream, LongPredicate predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.anyMatch(predicate), stream.allMatch(predicate.negate()), stream.filter(predicate).findAny().isEmpty()});
        }

        boolean after(LongStream stream, LongPredicate predicate) {
            return stream.noneMatch(predicate);
        }
    }

    static final class LongStreamMin {
        LongStreamMin() {
        }

        OptionalLong before(LongStream stream) {
            return stream.sorted().findFirst();
        }

        OptionalLong after(LongStream stream) {
            return stream.min();
        }
    }

    static final class LongStreamIsNotEmpty {
        LongStreamIsNotEmpty() {
        }

        boolean before(LongStream stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() != 0L, stream.count() > 0L, stream.count() >= 1L, stream.findFirst().isPresent()});
        }

        boolean after(LongStream stream) {
            return stream.findAny().isPresent();
        }
    }

    static final class LongStreamIsEmpty {
        LongStreamIsEmpty() {
        }

        boolean before(LongStream stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() == 0L, stream.count() <= 0L, stream.count() < 1L, stream.findFirst().isEmpty()});
        }

        boolean after(LongStream stream) {
            return stream.findAny().isEmpty();
        }
    }

    static final class LongStreamFilterSorted {
        LongStreamFilterSorted() {
        }

        LongStream before(LongStream stream, LongPredicate predicate) {
            return stream.sorted().filter(predicate);
        }

        LongStream after(LongStream stream, LongPredicate predicate) {
            return stream.filter(predicate).sorted();
        }
    }

    static abstract class FlatMapOuterStreamAfterFlatMapToLong<T> {
        FlatMapOuterStreamAfterFlatMapToLong() {
        }

        abstract LongStream toLongStreamFunction(T var1);

        LongStream before(Stream<T> stream, LongFunction<? extends LongStream> function) {
            return stream.flatMapToLong(v -> this.toLongStreamFunction(v).flatMap(function));
        }

        LongStream after(Stream<T> stream, LongFunction<? extends LongStream> function) {
            return stream.flatMapToLong(v -> this.toLongStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class FlatMapOuterLongStreamAfterFlatMap {
        FlatMapOuterLongStreamAfterFlatMap() {
        }

        abstract LongStream toLongStreamFunction(long var1);

        LongStream before(LongStream stream, LongFunction<? extends LongStream> function) {
            return stream.flatMap(v -> this.toLongStreamFunction(v).flatMap(function));
        }

        LongStream after(LongStream stream, LongFunction<? extends LongStream> function) {
            return stream.flatMap(v -> this.toLongStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class MapOuterStreamAfterFlatMapToLong<T> {
        MapOuterStreamAfterFlatMapToLong() {
        }

        abstract LongStream toLongStreamFunction(T var1);

        LongStream before(Stream<T> stream, LongUnaryOperator function) {
            return stream.flatMapToLong(v -> this.toLongStreamFunction(v).map(function));
        }

        LongStream after(Stream<T> stream, LongUnaryOperator function) {
            return stream.flatMapToLong(v -> this.toLongStreamFunction(v)).map(function);
        }
    }

    static abstract class MapOuterLongStreamAfterFlatMap {
        MapOuterLongStreamAfterFlatMap() {
        }

        abstract LongStream toLongStreamFunction(long var1);

        LongStream before(LongStream stream, LongUnaryOperator function) {
            return stream.flatMap(v -> this.toLongStreamFunction(v).map(function));
        }

        LongStream after(LongStream stream, LongUnaryOperator function) {
            return stream.flatMap(v -> this.toLongStreamFunction(v)).map(function);
        }
    }

    static abstract class FilterOuterStreamAfterFlatMapToLong<T> {
        FilterOuterStreamAfterFlatMapToLong() {
        }

        abstract LongStream toLongStreamFunction(T var1);

        LongStream before(Stream<T> stream, LongPredicate predicate) {
            return stream.flatMapToLong(v -> this.toLongStreamFunction(v).filter(predicate));
        }

        LongStream after(Stream<T> stream, LongPredicate predicate) {
            return stream.flatMapToLong(v -> this.toLongStreamFunction(v)).filter(predicate);
        }
    }

    static abstract class FilterOuterLongStreamAfterFlatMap {
        FilterOuterLongStreamAfterFlatMap() {
        }

        abstract LongStream toLongStreamFunction(long var1);

        LongStream before(LongStream stream, LongPredicate predicate) {
            return stream.flatMap(v -> this.toLongStreamFunction(v).filter(predicate));
        }

        LongStream after(LongStream stream, LongPredicate predicate) {
            return stream.flatMap(v -> this.toLongStreamFunction(v)).filter(predicate);
        }
    }

    static final class ConcatTwoLongStreams {
        ConcatTwoLongStreams() {
        }

        LongStream before(LongStream s1, LongStream s2) {
            return Streams.concat((LongStream[])new LongStream[]{s1, s2});
        }

        LongStream after(LongStream s1, LongStream s2) {
            return LongStream.concat(s1, s2);
        }
    }

    static final class ConcatOneLongStream {
        ConcatOneLongStream() {
        }

        LongStream before(LongStream stream) {
            return Streams.concat((LongStream[])new LongStream[]{stream});
        }

        @CanIgnoreReturnValue
        LongStream after(LongStream stream) {
            return stream;
        }
    }

    static final class LongStreamClosedOpenRange {
        LongStreamClosedOpenRange() {
        }

        LongStream before(long from, long to) {
            return LongStream.rangeClosed(from, to - 1L);
        }

        LongStream after(long from, long to) {
            return LongStream.range(from, to);
        }
    }
}

