/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.camel40.java;

import io.quarkus.updates.camel.AbstractCamelQuarkusJavaVisitor;
import io.quarkus.updates.camel.RecipesUtil;
import java.beans.SimpleBeanInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.ImplementInterface;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveImplements;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class CamelAPIsRecipe
extends Recipe {
    private static final String MATCHER_CONTEXT_GET_ENDPOINT_MAP = "org.apache.camel.CamelContext getEndpointMap()";
    private static final String MATCHER_CONTEXT_GET_EXT = "org.apache.camel.CamelContext getExtension(java.lang.Class)";
    private static final String MATCHER_GET_NAME_RESOLVER = "org.apache.camel.ExtendedCamelContext getComponentNameResolver()";
    private static final String M_PRODUCER_TEMPLATE_ASYNC_CALLBACK = "org.apache.camel.ProducerTemplate asyncCallback(..)";
    private static final String M_CONTEXT_ADAPT = "org.apache.camel.CamelContext adapt(java.lang.Class)";
    private static final String M_CONTEXT_SET_DUMP_ROUTES = "org.apache.camel.CamelContext setDumpRoutes(java.lang.Boolean)";
    private static final String M_CONTEXT_IS_DUMP_ROUTES = "org.apache.camel.CamelContext isDumpRoutes()";
    private static final String M_EXCHANGE_ADAPT = "org.apache.camel.Exchange adapt(java.lang.Class)";
    private static final String M_EXCHANGE_GET_PROPERTY = "org.apache.camel.Exchange getProperty(org.apache.camel.ExchangePropertyKey)";
    private static final String M_EXCHANGE_REMOVE_PROPERTY = "org.apache.camel.Exchange removeProperty(org.apache.camel.ExchangePropertyKey)";
    private static final String M_EXCHANGE_SET_PROPERTY = "org.apache.camel.Exchange setProperty(..)";
    private static final String M_CATALOG_ARCHETYPE_AS_XML = "org.apache.camel.catalog.CamelCatalog archetypeCatalogAsXml()";

    public String getDisplayName() {
        return "Camel API changes";
    }

    public String getDescription() {
        return "Apache Camel API migration from version 3.20 or higher to 4.0. Removal of deprecated APIs.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelQuarkusJavaVisitor(){
            private Map<UUID, Tree> adaptCache = new HashMap<UUID, Tree>();

            @Override
            protected J.Import doVisitImport(J.Import _import, ExecutionContext context) {
                J.Import im = super.doVisitImport(_import, context);
                if (im.isStatic() && im.getTypeName().equals("org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy") && im.getQualid() != null && ("Discard".equals(im.getQualid().getSimpleName()) || "DiscardOldest".equals(im.getQualid().getSimpleName()))) {
                    Comment comment = RecipesUtil.createMultinlineComment(String.format("'ThreadPoolRejectedPolicy.%s' has been removed, consider using 'ThreadPoolRejectedPolicy.Abort'.", im.getQualid().getSimpleName()));
                    im = (J.Import)im.withComments(Collections.singletonList(comment));
                } else if ("org.apache.camel.builder.SimpleBuilder".equals(im.getTypeName())) {
                    Comment comment = RecipesUtil.createMultinlineComment(String.format("'%s' has been removed, (class was used internally).", SimpleBeanInfo.class.getCanonicalName()));
                    im = (J.Import)im.withComments(Collections.singletonList(comment));
                }
                this.doAfterVisit(new ChangeType("org.apache.camel.api.management.mbean.BacklogTracerEventMessage", "org.apache.camel.spi.BacklogTracerEventMessage", Boolean.valueOf(true)).getVisitor());
                return im;
            }

            @Override
            protected J.ClassDeclaration doVisitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
                J.ClassDeclaration cd = super.doVisitClassDeclaration(classDecl, context);
                if (cd.getImplements() != null && cd.getImplements().stream().anyMatch(f -> TypeUtils.isOfClassType((JavaType)f.getType(), (String)"org.apache.camel.spi.OnCamelContextStart"))) {
                    this.doAfterVisit((TreeVisitor)new ImplementInterface(cd, "org.apache.camel.spi.OnCamelContextStarting"));
                    this.doAfterVisit(new RemoveImplements("org.apache.camel.spi.OnCamelContextStart", null).getVisitor());
                } else if (cd.getImplements() != null && cd.getImplements().stream().anyMatch(f -> TypeUtils.isOfClassType((JavaType)f.getType(), (String)"org.apache.camel.spi.OnCamelContextStop"))) {
                    this.doAfterVisit((TreeVisitor)new ImplementInterface(cd, "org.apache.camel.spi.OnCamelContextStopping"));
                    this.doAfterVisit(new RemoveImplements("org.apache.camel.spi.OnCamelContextStop", null).getVisitor());
                }
                return cd;
            }

            @Override
            protected J.FieldAccess doVisitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
                J.FieldAccess fa = super.doVisitFieldAccess(fieldAccess, context);
                if ("InOptionalOut".equals(fieldAccess.getSimpleName()) && fa.getType() != null && fa.getType().isAssignableFrom(Pattern.compile("org.apache.camel.ExchangePattern"))) {
                    return fa.withName(new J.Identifier(UUID.randomUUID(), fa.getPrefix(), Markers.EMPTY, Collections.emptyList(), "/* " + fa.getSimpleName() + " has been removed */", fa.getType(), null));
                }
                if (("Discard".equals(fa.getSimpleName()) || "DiscardOldest".equals(fa.getSimpleName())) && fa.getType() != null && fa.getType().isAssignableFrom(Pattern.compile("org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy"))) {
                    Comment comment = RecipesUtil.createMultinlineComment(String.format("'ThreadPoolRejectedPolicy.%s' has been removed, consider using 'ThreadPoolRejectedPolicy.Abort'.", fa.getSimpleName()));
                    fa = (J.FieldAccess)fa.withComments(Collections.singletonList(comment));
                }
                return fa;
            }

            @Override
            protected J.MethodDeclaration doVisitMethodDeclaration(J.MethodDeclaration method, ExecutionContext context) {
                J.MethodDeclaration md = super.doVisitMethodDeclaration(method, context);
                if ("configure".equals(md.getSimpleName()) && JavaType.Primitive.Void.equals((Object)md.getReturnTypeExpression().getType()) && md.getMethodType().getDeclaringType().isAssignableFrom(Pattern.compile("org.apache.camel.main.MainListener")) && !md.getParameters().isEmpty() && md.getParameters().size() == 1 && md.getParameters().get(0) instanceof J.VariableDeclarations && ((J.VariableDeclarations)md.getParameters().get(0)).getType().isAssignableFrom(Pattern.compile("org.apache.camel.CamelContext"))) {
                    Comment comment = RecipesUtil.createMultinlineComment(String.format(" Method '%s' was removed from `%s`, consider using 'beforeConfigure' or 'afterConfigure'. ", md.getSimpleName(), "org.apache.camel.main.MainListener"));
                    md = (J.MethodDeclaration)md.withComments(Collections.singletonList(comment));
                }
                return md;
            }

            @Override
            protected J.Annotation doVisitAnnotation(J.Annotation annotation, ExecutionContext context) {
                Optional<String> originalValue;
                J.Annotation a = super.doVisitAnnotation(annotation, context);
                if (a.getType().toString().equals("org.apache.camel.FallbackConverter")) {
                    this.maybeAddImport("org.apache.camel.Converter", null, false);
                    this.maybeRemoveImport("org.apache.camel.FallbackConverter");
                    return RecipesUtil.createAnnotation(annotation, "Converter", null, "fallback = true");
                }
                if (a.getType().toString().equals("org.apache.camel.EndpointInject")) {
                    Optional<String> originalValue2 = RecipesUtil.getValueOfArgs(a.getArguments(), "uri");
                    if (originalValue2.isPresent()) {
                        return RecipesUtil.createAnnotation(annotation, "EndpointInject", s -> s.startsWith("uri="), originalValue2.get());
                    }
                } else if (a.getType().toString().equals("org.apache.camel.Produce")) {
                    Optional<String> originalValue3 = RecipesUtil.getValueOfArgs(a.getArguments(), "uri");
                    if (originalValue3.isPresent()) {
                        return RecipesUtil.createAnnotation(annotation, "Produce", s -> s.startsWith("uri="), originalValue3.get());
                    }
                } else if (a.getType().toString().equals("org.apache.camel.Consume")) {
                    Optional<String> originalValue4 = RecipesUtil.getValueOfArgs(a.getArguments(), "uri");
                    if (originalValue4.isPresent()) {
                        return RecipesUtil.createAnnotation(annotation, "Consume", s -> s.startsWith("uri="), originalValue4.get());
                    }
                } else if (a.getType().toString().equals("org.apache.camel.spi.UriEndpoint") && (originalValue = RecipesUtil.getValueOfArgs(a.getArguments(), "label")).isPresent()) {
                    Object newValue;
                    this.maybeAddImport("org.apache.camel.Category", null, false);
                    try {
                        newValue = RecipesUtil.Category.valueOf(originalValue.get().toUpperCase().replaceAll("\"", "")).getValue();
                    }
                    catch (IllegalArgumentException e) {
                        newValue = originalValue.get() + "/*unknown_value*/";
                    }
                    return RecipesUtil.createAnnotation(annotation, "UriEndpoint", s -> s.startsWith("label="), "category = {Category." + (String)newValue + "}");
                }
                return a;
            }

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, context);
                if (mi.getSelect() != null && this.adaptCache.containsKey(mi.getSelect().getId())) {
                    this.getCursor().putMessage("adapt_cast", (Object)mi.getSelect().getId());
                } else if (this.getMethodMatcher(CamelAPIsRecipe.MATCHER_CONTEXT_GET_ENDPOINT_MAP).matches(mi, false)) {
                    mi = mi.withName(new J.Identifier(UUID.randomUUID(), mi.getPrefix(), Markers.EMPTY, Collections.emptyList(), "/* " + mi.getSimpleName() + " has been removed, consider getEndpointRegistry() instead */", mi.getType(), null));
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_PRODUCER_TEMPLATE_ASYNC_CALLBACK).matches(mi, false)) {
                    Comment comment = RecipesUtil.createMultinlineComment(String.format(" Method '%s()' has been replaced by 'asyncSend()' or 'asyncRequest()'.", mi.getSimpleName()));
                    mi = (J.MethodInvocation)mi.withComments(Collections.singletonList(comment));
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_CONTEXT_ADAPT).matches(mi, false)) {
                    if (mi.getType().isAssignableFrom(Pattern.compile("org.apache.camel.model.ModelCamelContext"))) {
                        J.Identifier type = RecipesUtil.createIdentifier(mi.getPrefix(), "ModelCamelContext", "java.lang.Object");
                        J.ControlParentheses cp = RecipesUtil.createParentheses(RecipesUtil.createTypeCast(type, mi.getSelect()));
                        mi = (J.MethodInvocation)mi.withComments(Collections.singletonList(RecipesUtil.createMultinlineComment("Method 'adapt' was removed.")));
                        this.adaptCache.put(method.getId(), (Tree)cp);
                    } else if (mi.getType().isAssignableFrom(Pattern.compile("org.apache.camel.ExtendedCamelContext"))) {
                        mi = mi.withName(mi.getName().withSimpleName("getCamelContextExtension")).withArguments(Collections.emptyList());
                        this.maybeRemoveImport("org.apache.camel.ExtendedCamelContext");
                    }
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_EXCHANGE_ADAPT).matches(mi, false) && mi.getType().isAssignableFrom(Pattern.compile("org.apache.camel.ExtendedExchange"))) {
                    mi = mi.withName(mi.getName().withSimpleName("getExchangeExtension")).withArguments(Collections.emptyList());
                    this.maybeRemoveImport("org.apache.camel.ExtendedExchange");
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_EXCHANGE_GET_PROPERTY).matches(mi, false) && ((Expression)mi.getArguments().get(0)).toString().endsWith("FAILURE_HANDLED")) {
                    mi = mi.withName(mi.getName().withSimpleName("getExchangeExtension().isFailureHandled")).withArguments(Collections.emptyList());
                    this.maybeRemoveImport("org.apache.camel.ExchangePropertyKey");
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_EXCHANGE_REMOVE_PROPERTY).matches(mi, false) && ((Expression)mi.getArguments().get(0)).toString().endsWith("FAILURE_HANDLED")) {
                    mi = mi.withName(mi.getName().withSimpleName("getExchangeExtension().setFailureHandled")).withArguments(Collections.singletonList(RecipesUtil.createIdentifier(Space.EMPTY, "false", "java.lang.Boolean")));
                    this.maybeRemoveImport("org.apache.camel.ExchangePropertyKey");
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_EXCHANGE_SET_PROPERTY).matches(mi, false) && ((Expression)mi.getArguments().get(0)).toString().endsWith("FAILURE_HANDLED")) {
                    mi = mi.withName(mi.getName().withSimpleName("getExchangeExtension().setFailureHandled")).withArguments(Collections.singletonList((Expression)((Expression)mi.getArguments().get(1)).withPrefix(Space.EMPTY)));
                    this.maybeRemoveImport("org.apache.camel.ExchangePropertyKey");
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_CATALOG_ARCHETYPE_AS_XML).matches(mi, false)) {
                    mi = (J.MethodInvocation)mi.withComments(Collections.singletonList(RecipesUtil.createMultinlineComment(" Method '" + mi.getSimpleName() + "' has been removed. ")));
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_CONTEXT_SET_DUMP_ROUTES).matches(mi, false)) {
                    mi = (J.MethodInvocation)mi.withComments(Collections.singletonList(RecipesUtil.createMultinlineComment(" Method '" + mi.getSimpleName() + "' accepts String parameter ('xml' or 'yaml' or 'false'). ")));
                } else if (this.getMethodMatcher(CamelAPIsRecipe.M_CONTEXT_IS_DUMP_ROUTES).matches(mi, false)) {
                    mi = (J.MethodInvocation)mi.withName(mi.getName().withSimpleName("getDumpRoutes")).withComments(Collections.singletonList(RecipesUtil.createMultinlineComment(" Method 'getDumpRoutes' returns String value ('xml' or 'yaml' or 'false'). ")));
                } else if (this.getMethodMatcher(CamelAPIsRecipe.MATCHER_GET_NAME_RESOLVER).matches((MethodCall)mi)) {
                    if (mi.getSelect() instanceof J.MethodInvocation && this.getMethodMatcher(CamelAPIsRecipe.MATCHER_CONTEXT_GET_EXT).matches(((J.MethodInvocation)mi.getSelect()).getMethodType())) {
                        J.MethodInvocation innerInvocation = (J.MethodInvocation)mi.getSelect();
                        mi = (J.MethodInvocation)JavaTemplate.builder((String)"PluginHelper.getComponentNameResolver(#{any(org.apache.camel.CamelContext)})").build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{innerInvocation.getSelect()});
                        this.doAfterVisit((TreeVisitor)new AddImport("org.apache.camel.support.PluginHelper", null, false));
                    }
                } else if (this.getMethodMatcher(CamelAPIsRecipe.MATCHER_CONTEXT_GET_EXT).matches(mi, false)) {
                    mi = mi.withName(mi.getName().withSimpleName("getCamelContextExtension().getContextPlugin")).withMethodType(mi.getMethodType());
                    if (this.getCursor().getParent().getValue() instanceof J.TypeCast && ((J.TypeCast)this.getCursor().getParent().getValue()).getType().equals(mi.getType())) {
                        this.getCursor().getParent().putMessage("remove_type_cast", (Object)mi);
                    }
                }
                return mi;
            }

            @Nullable
            public J postVisit(J tree, ExecutionContext context) {
                J j = (J)super.postVisit((Tree)tree, (Object)context);
                UUID adaptCast = (UUID)this.getCursor().getMessage("adapt_cast");
                if (adaptCast != null) {
                    J.MethodInvocation mi = (J.MethodInvocation)j;
                    J.ControlParentheses cp = (J.ControlParentheses)this.adaptCache.get(adaptCast);
                    J.MethodInvocation m = mi.withSelect((Expression)cp);
                    return m;
                }
                J removeTypeCast = (J)this.getCursor().getMessage("remove_type_cast");
                if (removeTypeCast != null) {
                    return removeTypeCast;
                }
                return j;
            }
        });
    }

    @NonNull
    public String toString() {
        return "CamelAPIsRecipe()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelAPIsRecipe)) {
            return false;
        }
        CamelAPIsRecipe other = (CamelAPIsRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelAPIsRecipe;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

