/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.camel40.java;

import io.quarkus.updates.camel.AbstractCamelQuarkusJavaVisitor;
import io.quarkus.updates.camel.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public final class CamelHttpRecipe
extends Recipe {
    private static final String SET_CREDENTIALS = "org.apache.http.impl.client.BasicCredentialsProvider setCredentials(..)";
    private static final String SCOPE_ANY = "AuthScope.ANY";

    public String getDisplayName() {
        return "Camel Http Extension changes";
    }

    public String getDescription() {
        return "Camel Http Extension changes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor("org.apache.http..*", new AbstractCamelQuarkusJavaVisitor(){

            @Override
            protected J.Import doVisitImport(J.Import _import, ExecutionContext context) {
                this.doAfterVisit(new ChangeType("org.apache.http.HttpHost", "org.apache.hc.core5.http.HttpHost", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.client.protocol.HttpClientContext", "org.apache.hc.client5.http.protocol.HttpClientContext", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.protocol.HttpContext", "org.apache.hc.core5.http.protocol.HttpContext", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.impl.auth.BasicScheme", "org.apache.hc.client5.http.impl.auth.BasicScheme", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.impl.client.BasicAuthCache", "org.apache.hc.client5.http.impl.auth.BasicAuthCache", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.impl.client.BasicCredentialsProvider", "org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.auth.AuthScope", "org.apache.hc.client5.http.auth.AuthScope", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.auth.UsernamePasswordCredentials", "org.apache.hc.client5.http.auth.UsernamePasswordCredentials", Boolean.valueOf(true)).getVisitor());
                this.doAfterVisit(new ChangeType("org.apache.http.conn.ssl.NoopHostnameVerifier", "org.apache.hc.client5.http.conn.ssl.NoopHostnameVerifier", Boolean.valueOf(true)).getVisitor());
                return super.doVisitImport(_import, context);
            }

            @Override
            protected J.FieldAccess doVisitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext context) {
                J.FieldAccess f = super.doVisitFieldAccess(fieldAccess, context);
                if ("ANY".equals(f.getSimpleName()) && "org.apache.http.auth.AuthScope".equals(f.getType().toString())) {
                    JavaTemplate.Builder templateBuilder = JavaTemplate.builder((String)"new AuthScope(null, -1)");
                    J.NewClass nc = (J.NewClass)templateBuilder.build().apply(this.updateCursor((Tree)fieldAccess), f.getCoordinates().replace(), new Object[0]).withPrefix(f.getPrefix());
                    this.getCursor().putMessage("authScopeNewClass", (Object)nc);
                }
                return f;
            }

            @Nullable
            public J postVisit(J tree, ExecutionContext context) {
                J j = (J)super.postVisit((Tree)tree, (Object)context);
                J.NewClass newClass = (J.NewClass)this.getCursor().getMessage("authScopeNewClass");
                if (newClass != null) {
                    this.maybeAddImport("org.apache.hc.client5.http.auth.AuthScope", null, false);
                    return newClass;
                }
                return j;
            }
        });
    }

    @NonNull
    public String toString() {
        return "CamelHttpRecipe()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelHttpRecipe)) {
            return false;
        }
        CamelHttpRecipe other = (CamelHttpRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelHttpRecipe;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

