/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.customRecipes;

import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyKeyWithCaseChange
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename.")
    private final String oldPropertyKey;
    @Option(displayName="New prefix before any group", description="The prefix to be replaced with.")
    private final String newPrefix;

    public String getDisplayName() {
        return "Change prefix of property with Camel case";
    }

    public String getDescription() {
        return "Change prefix of property with Camel case";
    }

    public PropertiesVisitor<ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            public Properties visitEntry(Properties.Entry entry, ExecutionContext p) {
                if (entry.getKey().matches(ChangePropertyKeyWithCaseChange.this.oldPropertyKey)) {
                    entry = entry.withKey(this.getKey(entry)).withPrefix(entry.getPrefix());
                }
                return super.visitEntry(entry, (Object)p);
            }

            private String getKey(Properties.Entry entry) {
                return ChangePropertyKeyWithCaseChange.this.newPrefix + entry.getKey().replaceFirst(ChangePropertyKeyWithCaseChange.this.oldPropertyKey, "$1").substring(0, 1).toLowerCase() + entry.getKey().replaceFirst(ChangePropertyKeyWithCaseChange.this.oldPropertyKey, "$1").substring(1);
            }
        };
    }

    @ConstructorProperties(value={"oldPropertyKey", "newPrefix"})
    public ChangePropertyKeyWithCaseChange(String oldPropertyKey, String newPrefix) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPrefix = newPrefix;
    }

    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    public String getNewPrefix() {
        return this.newPrefix;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyKeyWithCaseChange(oldPropertyKey=" + this.getOldPropertyKey() + ", newPrefix=" + this.getNewPrefix() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKeyWithCaseChange)) {
            return false;
        }
        ChangePropertyKeyWithCaseChange other = (ChangePropertyKeyWithCaseChange)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPrefix = this.getNewPrefix();
        String other$newPrefix = other.getNewPrefix();
        return !(this$newPrefix == null ? other$newPrefix != null : !this$newPrefix.equals(other$newPrefix));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKeyWithCaseChange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPrefix = this.getNewPrefix();
        result = result * 59 + ($newPrefix == null ? 43 : $newPrefix.hashCode());
        return result;
    }
}

