/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import tech.picnic.errorprone.utils.MoreASTHelpers;

@BugPattern(summary="Don't unnecessarily pass a type to Mockito's `mock(Class)` and `spy(Class)` methods", link="https://error-prone.picnic.tech/bugpatterns/MockitoMockClassReference", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class MockitoMockClassReference
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<MethodInvocationTree> MOCKITO_MOCK_OR_SPY_WITH_HARDCODED_TYPE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.argument((int)0, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSameType((String)Class.class.getCanonicalName()), Matchers.not((Matcher)Matchers.isVariable())})), Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf(new String[]{"mock", "spy"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MOCKITO_MOCK_OR_SPY_WITH_HARDCODED_TYPE.matches((Tree)tree, state) || !MockitoMockClassReference.isTypeDerivableFromContext(tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        return this.describeMatch(tree, (Fix)SuggestedFixes.removeElement((Tree)arguments.get(0), arguments, (VisitorState)state));
    }

    private static boolean isTypeDerivableFromContext(MethodInvocationTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        return switch (parent.getKind()) {
            case Tree.Kind.VARIABLE -> {
                if (!ASTHelpers.hasImplicitType((VariableTree)((VariableTree)parent), (VisitorState)state) && MoreASTHelpers.areSameType((Tree)tree, (Tree)parent, (VisitorState)state)) {
                    yield true;
                }
                yield false;
            }
            case Tree.Kind.ASSIGNMENT -> MoreASTHelpers.areSameType((Tree)tree, (Tree)parent, (VisitorState)state);
            case Tree.Kind.RETURN -> MoreASTHelpers.findMethodExitedOnReturn((VisitorState)state).filter(m -> MoreASTHelpers.areSameType((Tree)tree, (Tree)m.getReturnType(), (VisitorState)state)).isPresent();
            default -> false;
        };
    }
}

